/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.armor.CardboardArmorItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCGUtil {
    public static Minecraft mc = Minecraft.getInstance();

    @Contract(pure=true)
    public static boolean isInGUI() {
        return CCGUtil.mc.screen != null;
    }

    @Contract(pure=true)
    public static boolean isInGame() {
        return CCGUtil.mc.screen == null;
    }

    @Nullable
    public static <T> T getAs(@NotNull Class<T> clazz, Object object) {
        return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
    }

    @Contract(pure=true)
    @Nullable
    public static BlockHitResult getBlockHitResult() {
        BlockHitResult result;
        HitResult hitResult = CCGUtil.mc.hitResult;
        return hitResult instanceof BlockHitResult ? (result = (BlockHitResult)hitResult) : null;
    }

    @Contract(pure=true)
    @Nullable
    public static EntityHitResult getEntityHitResult() {
        EntityHitResult result;
        HitResult hitResult = CCGUtil.mc.hitResult;
        return hitResult instanceof EntityHitResult ? (result = (EntityHitResult)hitResult) : null;
    }

    @Nullable
    public static BlockEntity getBlockEntity() {
        if (CCGUtil.mc.level == null) {
            return null;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null) {
            return null;
        }
        return result.getType() == HitResult.Type.MISS ? null : CCGUtil.mc.level.getBlockEntity(result.getBlockPos());
    }

    public static <T> T getBlockEntity(Class<T> clazz) {
        return CCGUtil.getAs(clazz, CCGUtil.getBlockEntity());
    }

    @Nullable
    public static Block getBlock() {
        if (CCGUtil.mc.level == null) {
            return null;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null) {
            return null;
        }
        if (result.getType() == HitResult.Type.MISS) {
            return null;
        }
        return CCGUtil.mc.level.getBlockState(result.getBlockPos()).getBlock();
    }

    @Nullable
    public static Entity getEntity() {
        EntityHitResult result = CCGUtil.getEntityHitResult();
        return result != null ? result.getEntity() : null;
    }

    @Nullable
    public static ItemStack getRelevantFilterItem() {
        if (CCGUtil.isInGUI()) {
            Screen screen = CCGUtil.mc.screen;
            if (!(screen instanceof AbstractContainerScreen)) {
                return null;
            }
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot slot = screen2.getSlotUnderMouse();
            return slot == null ? null : slot.getItem();
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        SmartBlockEntity sbe = CCGUtil.getBlockEntity(SmartBlockEntity.class);
        if (sbe == null || result == null) {
            return null;
        }
        FilteringBehaviour behaviour = (FilteringBehaviour)sbe.getBehaviour(FilteringBehaviour.TYPE);
        return behaviour == null ? ItemStack.EMPTY : behaviour.getFilter(result.getDirection());
    }

    @NotNull
    public static AABB getBounds(BlockPos blockPos) {
        if (CCGUtil.mc.level == null) {
            return Shapes.block().bounds();
        }
        VoxelShape shape = CCGUtil.mc.level.getBlockState(blockPos).getShape((BlockGetter)CCGUtil.mc.level, blockPos);
        return (shape.isEmpty() ? Shapes.block() : shape).bounds().move(blockPos);
    }

    @Contract(pure=true)
    public static int getGradientColor(float progress) {
        return Color.HSBtoRGB(progress * 0.33f, 1.0f, 1.0f);
    }

    public static boolean testForStealth(LocalPlayer player) {
        boolean allMatch = Stream.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET).allMatch(slot -> player.getItemBySlot(slot).getItem() instanceof CardboardArmorItem);
        return CCG.CONFIG.chainConveyor.cardBoardedYourself && !player.getAbilities().flying && allMatch;
    }

    public static void displayMessage(LangBuilder builder) {
        LocalPlayer player = CCGUtil.mc.player;
        if (player != null) {
            player.displayClientMessage((Component)builder.component(), true);
        }
    }

    public static void playSound(SoundEvent sound, float pitch, float volume) {
        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void playSound(AllSoundEvents.SoundEntry entry) {
        CCGUtil.playSound(entry.getMainEvent(), 0.25f, 1.0f);
    }

    public static void playSound(SoundEvent sound) {
        CCGUtil.playSound(sound, 1.0f, 1.0f);
    }

    public static void toggleConfig(boolean keyDown, boolean enabled, Consumer<Boolean> setter, String messageKey) {
        if (!keyDown) {
            return;
        }
        if (CCGUtil.isInGUI()) {
            return;
        }
        setter.accept(!enabled);
        CCGUtil.displayMessage(CCGLang.translate(messageKey, new Object[0]).space().translate(enabled ? "message.disabled" : "message.enabled", new Object[0]).style(enabled ? ChatFormatting.RED : ChatFormatting.GREEN));
        CCGUtil.playSound(!enabled ? AllSoundEvents.CONFIRM_2 : AllSoundEvents.DENY);
    }
}

