/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.RotationPropagatorAccessor;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;

public class KineticParticle {
    public static void tick(TickEvent.ClientTickEvent ignoredEvent) {
        if (!CCG.CONFIG.goggles.enableKineticEffect || CCGUtil.mc.f_91073_ == null || CCGUtil.isInGUI()) {
            return;
        }
        KineticBlockEntity kbe = CCGUtil.getBlockEntity(KineticBlockEntity.class);
        if (kbe == null) {
            return;
        }
        float kbeSpeed = kbe.getSpeed();
        if (kbeSpeed == 0.0f) {
            return;
        }
        BlockState state = kbe.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof KineticBlock)) {
            return;
        }
        KineticBlock kb = (KineticBlock)block;
        Vec3 center = VecHelper.getCenterOf((Vec3i)kbe.m_58899_());
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of((float)kbeSpeed);
        float particleSpeed = (float)Math.max(10, speedLevel.getParticleSpeed()) * Math.signum(kbeSpeed);
        if (KineticParticle.renderShaftParticles(kbe, kb, state, center, speedLevel.getColor(), particleSpeed)) {
            return;
        }
        if (kb instanceof BeltBlock) {
            return;
        }
        KineticParticle.renderDefaultParticles(kb, state, center, speedLevel.getColor(), particleSpeed);
    }

    private static boolean renderShaftParticles(KineticBlockEntity kbe, KineticBlock kb, BlockState state, Vec3 center, int color, float particleSpeed) {
        boolean hasRendered = false;
        for (Direction direction : Direction.values()) {
            if (!kb.hasShaftTowards((LevelReader)CCGUtil.mc.f_91073_, kbe.m_58899_(), state, direction)) continue;
            Direction.Axis axis = direction.m_122434_();
            float directionSpeed = particleSpeed * RotationPropagatorAccessor.getAxisModifier(kbe, direction);
            double offset = (double)direction.m_122421_().m_122540_() / 2.0;
            Vec3 axisVec = new Vec3(axis == Direction.Axis.X ? offset : 0.0, axis == Direction.Axis.Y ? offset : 0.0, axis == Direction.Axis.Z ? offset : 0.0);
            Vec3 pos = center.m_82549_(axisVec);
            float initial = Mth.m_14036_((float)(kb.getParticleInitialRadius() / 2.0f), (float)0.2f, (float)0.3f);
            float target = Mth.m_14036_((float)(kb.getParticleTargetRadius() / 2.0f), (float)0.4f, (float)0.5f);
            RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, directionSpeed, initial, target, 10, axis.name().charAt(0));
            KineticParticle.spawnParticles(particleData, pos);
            hasRendered = true;
        }
        if (kb instanceof EncasedCogwheelBlock) {
            return false;
        }
        return hasRendered;
    }

    private static void renderDefaultParticles(@NotNull KineticBlock kb, BlockState state, Vec3 center, int color, float particleSpeed) {
        float initial = kb.getParticleInitialRadius();
        float target = kb.getParticleTargetRadius();
        char axisChar = kb.getRotationAxis(state).name().charAt(0);
        RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, initial, target, 10, axisChar);
        KineticParticle.spawnParticles(particleData, center);
    }

    private static void spawnParticles(RotationIndicatorParticleData particleData, Vec3 pos) {
        if (CCGUtil.mc.f_91073_ == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            CCGUtil.mc.f_91073_.m_7106_((ParticleOptions)particleData, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        }
    }
}

