/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.IItemRenderable;
import java.util.List;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayRenderer {
    public static int hoverTicks;
    public static float fade;
    public static ItemStack currentItemStack;

    public static void register(@NotNull RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "goggle_overlay", OverlayRenderer::renderOverlay);
    }

    public static void color(@NotNull RenderTooltipEvent.Color event) {
        Color colorBackground;
        if (!event.getItemStack().equals(currentItemStack) || currentItemStack.m_41619_()) {
            return;
        }
        CClient cfg = AllConfigs.client();
        Color color = colorBackground = (Boolean)cfg.overlayCustomColor.get() != false ? new Color(((Integer)cfg.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
        if (fade < 1.0f) {
            colorBackground.scaleAlpha(fade);
        }
        event.setBackground(colorBackground.getRGB());
    }

    public static void renderOverlay(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        ItemStack itemStack;
        if (!CCG.CONFIG.goggles.renderExtraItems || !CCG.CONFIG.gameMode.enableGoggle) {
            return;
        }
        if (CCGUtil.mc.m_91104_() || CCGUtil.isInGUI() || CCGUtil.mc.f_91066_.f_92062_) {
            currentItemStack = null;
            hoverTicks = 0;
            return;
        }
        if (!CCG.CONFIG.goggles.canRenderOnValueBox) {
            for (Outliner.OutlineEntry entry : CCGUtil.outliner.getOutlines().values()) {
                Outline outline;
                if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
                return;
            }
        }
        fade = Mth.m_14036_((float)(((float)hoverTicks++ + partialTicks) / 24.0f), (float)0.0f, (float)1.0f);
        currentItemStack = itemStack = OverlayRenderer.toRenderItemStack();
        if (itemStack == null || itemStack.m_41619_()) {
            hoverTicks = 0;
            return;
        }
        OverlayRenderer.renderItemStack(guiGraphics, itemStack);
    }

    @Nullable
    public static ItemStack toRenderItemStack() {
        BlockEntity blockEntity = CCGUtil.getBlockEntity();
        if (blockEntity instanceof IItemRenderable) {
            IItemRenderable renderable = (IItemRenderable)blockEntity;
            return renderable.ccg$getItemStack();
        }
        blockEntity = CCGUtil.getEntity();
        if (blockEntity instanceof IItemRenderable) {
            IItemRenderable renderable = (IItemRenderable)blockEntity;
            return renderable.ccg$getItemStack();
        }
        return null;
    }

    public static void renderItemStack(GuiGraphics guiGraphics, ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return;
        }
        Font font = CCGUtil.mc.f_91062_;
        TooltipFlag.Default flag = new TooltipFlag.Default(CCGUtil.mc.f_91066_.f_92125_, true);
        List tooltip = itemStack.m_41651_((Player)CCGUtil.mc.f_91074_, (TooltipFlag)flag);
        CClient cfg = AllConfigs.client();
        int tooltipTextWidth = tooltip.stream().mapToInt(arg_0 -> ((Font)CCGUtil.mc.f_91062_).m_92852_(arg_0)).max().orElse(0) + 24;
        int x = guiGraphics.m_280182_() / 2 + (Integer)cfg.overlayOffsetX.get();
        int y = guiGraphics.m_280206_() / 2 + (Integer)cfg.overlayOffsetY.get();
        if (x + tooltipTextWidth > guiGraphics.m_280182_()) {
            x = guiGraphics.m_280182_() - tooltipTextWidth;
        }
        if (fade < 1.0f) {
            x += (int)(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5f) * 8.0);
        }
        if (GoggleOverlayRenderer.hoverTicks != 0) {
            y -= (tooltip.size() + 1) * 10;
        }
        x = Math.max(16, x);
        y = Math.max(16, y);
        guiGraphics.m_280480_(itemStack, x - 10, y - 10);
        guiGraphics.m_280370_(font, itemStack, x - 10, y - 10);
        guiGraphics.m_280153_(font, itemStack, x, y);
    }
}

