/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGConfig;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.ItemRenderable;
import io.github.forgestove.create_cyber_goggles.core.util.TooltipFlagType;
import io.github.forgestove.create_cyber_goggles.core.util.TooltipTheme;
import java.util.List;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector2ic;

public class TooltipOverlay {
    public static int hoverTicks;

    public static void register(@NotNull RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, CCGUtil.getCCGRes("tooltip_overlay"), TooltipOverlay::renderOverlay);
    }

    public static void renderOverlay(GuiGraphics graphics, DeltaTracker deltaTracker) {
        if (!CCG.CONFIG.overlay.renderItemOverlay || !CCG.CONFIG.gameMode.enableGoggles) {
            return;
        }
        if (CCGUtil.mc.isPaused() || CCGUtil.isInGUI() || CCGUtil.mc.options.hideGui) {
            hoverTicks = 0;
            return;
        }
        if (!CCG.CONFIG.goggles.canRenderOnValueBox && CCGUtil.hasActivedValueBox()) {
            return;
        }
        ItemStack itemStack = TooltipOverlay.toRenderItemStack();
        if (itemStack.isEmpty()) {
            hoverTicks = 0;
        } else {
            TooltipOverlay.renderItemStack(graphics, itemStack);
        }
    }

    @NotNull
    public static ItemStack toRenderItemStack() {
        try {
            BlockEntity blockEntity = CCGUtil.getBlockEntity();
            if (blockEntity instanceof ItemRenderable) {
                ItemRenderable ir = (ItemRenderable)blockEntity;
                return CCGUtil.orEmpty(ir.ccg$getItemStack());
            }
            blockEntity = CCGUtil.getEntity();
            if (blockEntity instanceof ItemRenderable) {
                ItemRenderable ir = (ItemRenderable)blockEntity;
                return CCGUtil.orEmpty(ir.ccg$getItemStack());
            }
        }
        catch (Throwable e) {
            CCG.LOGGER.error("Failed to get item stack", e);
        }
        return ItemStack.EMPTY;
    }

    public static void renderItemStack(@NotNull GuiGraphics graphics, @NotNull ItemStack itemStack) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        CCGConfig.Overlay overlay = CCG.CONFIG.overlay;
        CClient cfg = AllConfigs.client();
        TooltipTheme.Theme theme = TooltipOverlay.getTheme();
        Color back = theme.backColor();
        Color top = theme.topColor();
        Color bot = theme.botColor();
        float fade = Mth.clamp((float)((CCGUtil.getRealtimeDeltaTicks() + (float)hoverTicks++) / 24.0f), (float)0.0f, (float)1.0f);
        if (fade < 1.0f) {
            pose.translate(Math.pow(1.0f - fade, 3.0) * Math.signum((double)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5) * 8.0, 0.0, 0.0);
            back.scaleAlpha(fade);
            top.scaleAlpha(fade);
            bot.scaleAlpha(fade);
        }
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        int x = width / 2 + (Integer)cfg.overlayOffsetX.get() + overlay.overlayOffsetX;
        int y = height / 2 + (Integer)cfg.overlayOffsetY.get() + overlay.overlayOffsetY;
        List<FormattedCharSequence> tooltips = TooltipOverlay.getFormattedTooltips(itemStack, width - x - 16);
        int tooltipWidth = tooltips.stream().mapToInt(arg_0 -> ((Font)CCGUtil.mc.font).width(arg_0)).max().orElse(0);
        int tooltipHeight = tooltips.size() * 10;
        if (GoggleOverlayRenderer.hoverTicks != 0) {
            y -= tooltipHeight + 10;
        }
        x = Mth.clamp((int)x, (int)0, (int)(width - tooltipWidth));
        y = Mth.clamp((int)y, (int)16, (int)(height - tooltipHeight - 100));
        TooltipOverlay.renderTooltip(graphics, itemStack, tooltips, x, y, tooltipWidth, tooltipHeight, back.getRGB(), top.getRGB(), bot.getRGB());
        pose.translate((float)x + 14.0f, (float)y - 14.0f, 450.0f);
        pose.scale(0.75f, 0.75f, 1.0f);
        graphics.renderItem(itemStack, 0, 0);
        graphics.renderItemDecorations(CCGUtil.mc.font, itemStack, 0, 0);
        pose.popPose();
    }

    @NotNull
    public static TooltipTheme.Theme getTheme() {
        CCGConfig.Overlay overlay = CCG.CONFIG.overlay;
        boolean useCCGCustom = overlay.useCustomColor;
        if (!useCCGCustom) {
            TooltipTheme.Theme theme;
            if (overlay.tooltipTheme == null) {
                overlay.tooltipTheme = TooltipTheme.Default;
            }
            if ((theme = overlay.tooltipTheme.theme) != null) {
                return theme;
            }
            CClient cfg = AllConfigs.client();
            Boolean useCreateCustom = (Boolean)cfg.overlayCustomColor.get();
            Color back = useCreateCustom != false ? new Color(((Integer)cfg.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
            Color top = useCreateCustom != false ? new Color(((Integer)cfg.overlayBorderColorTop.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getFirst()).copy();
            Color bot = useCreateCustom != false ? new Color(((Integer)cfg.overlayBorderColorBot.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getSecond()).copy();
            return new TooltipTheme.Theme(back, top, bot);
        }
        return new TooltipTheme.Theme(overlay.backgroundColor, overlay.borderTopColor, overlay.borderBottomColor);
    }

    @NotNull
    public static @Unmodifiable List<FormattedCharSequence> getFormattedTooltips(@NotNull ItemStack itemStack, int maxWidth) {
        CCGConfig.Overlay overlay = CCG.CONFIG.overlay;
        if (overlay.tooltipFlagType == null) {
            overlay.tooltipFlagType = TooltipFlagType.Default;
        }
        List tooltipLines = itemStack.getTooltipLines(Item.TooltipContext.of((Level)CCGUtil.mc.level), (Player)CCGUtil.mc.player, (TooltipFlag)overlay.tooltipFlagType.getFlag());
        tooltipLines.set(0, Component.literal((String)" ".repeat(Mth.ceil((float)(16.0f / (float)CCGUtil.mc.font.width(" "))))).append((Component)tooltipLines.getFirst()));
        return tooltipLines.stream().flatMap(line -> CCGUtil.mc.font.split((FormattedText)line, maxWidth).stream()).toList();
    }

    public static void renderTooltip(GuiGraphics graphics, ItemStack itemStack, @NotNull List<FormattedCharSequence> tooltips, int x, int y, int tooltipWidth, int tooltipHeight, int back, int top, int bot) {
        ClientTooltipPositioner positioner;
        int height;
        List<ClientTooltipComponent> components = tooltips.stream().map(ClientTooltipComponent::create).toList();
        if (components.isEmpty()) {
            return;
        }
        int width = graphics.guiWidth();
        if (ClientHooks.onRenderTooltipPre((ItemStack)itemStack, (GuiGraphics)graphics, (int)x, (int)y, (int)width, (int)(height = graphics.guiHeight()), components, (Font)CCGUtil.mc.font, (ClientTooltipPositioner)(positioner = DefaultTooltipPositioner.INSTANCE)).isCanceled()) {
            return;
        }
        Vector2ic tooltipPos = positioner.positionTooltip(width, height, x, y, tooltipWidth, tooltipHeight);
        int tooltipX = tooltipPos.x();
        int tooltipY = tooltipPos.y();
        PoseStack pose = graphics.pose();
        pose.pushPose();
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)tooltipX, (int)tooltipY, (int)tooltipWidth, (int)tooltipHeight, (int)400, (int)back, (int)back, (int)top, (int)bot);
        pose.translate(0.0f, 0.0f, 400.0f);
        int i = 0;
        int textY = tooltipY;
        for (ClientTooltipComponent component : components) {
            component.renderText(CCGUtil.mc.font, tooltipX, textY, pose.last().pose(), graphics.bufferSource());
            component.renderImage(CCGUtil.mc.font, tooltipX, textY, graphics);
            textY += component.getHeight() + (i == 0 ? 2 : 0);
            ++i;
        }
        pose.popPose();
    }
}

