/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.event;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.kinetics.fan.NozzleBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.Common;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DelayRender {
    public static Object2IntOpenHashMap<BlockEntity> cachedBE = new Object2IntOpenHashMap();

    public static void tick() {
        if (!CCG.CONFIG.delayRender.renderAnalogBox) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            cachedBE.clear();
            return;
        }
        if (mc.isPaused() || mc.screen != null) {
            return;
        }
        BlockEntity be = Common.getSelectedBE();
        if (be instanceof EncasedFanBlockEntity || be instanceof NozzleBlockEntity || be instanceof ArmBlockEntity || be instanceof EjectorBlockEntity) {
            cachedBE.put((Object)be, CCG.CONFIG.delayRender.delayRenderDuration);
        }
        if (cachedBE.isEmpty()) {
            return;
        }
        cachedBE.object2IntEntrySet().removeIf(entry -> {
            BlockEntity blockEntity = (BlockEntity)entry.getKey();
            int newValue = entry.getIntValue() - 1;
            entry.setValue(newValue);
            if (!blockEntity.isRemoved()) {
                BlockEntity blockEntity2 = blockEntity;
                Objects.requireNonNull(blockEntity2);
                BlockEntity selector0$temp = blockEntity2;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EncasedFanBlockEntity.class, NozzleBlockEntity.class, ArmBlockEntity.class, EjectorBlockEntity.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        EncasedFanBlockEntity efbe = (EncasedFanBlockEntity)selector0$temp;
                        DelayRender.render(efbe);
                        break;
                    }
                    case 1: {
                        NozzleBlockEntity nbe = (NozzleBlockEntity)selector0$temp;
                        DelayRender.render(nbe);
                        break;
                    }
                    case 2: {
                        ArmBlockEntity abe = (ArmBlockEntity)selector0$temp;
                        DelayRender.render(abe);
                        break;
                    }
                    case 3: {
                        EjectorBlockEntity ebe = (EjectorBlockEntity)selector0$temp;
                        DelayRender.render(ebe);
                        break;
                    }
                }
            }
            return newValue <= 0;
        });
    }

    public static void render(@NotNull EncasedFanBlockEntity efbe) {
        AirCurrent airCurrent = efbe.airCurrent;
        int color = DelayRender.getColor(airCurrent.pushing);
        AABB bounds = airCurrent.bounds;
        Outliner.getInstance().chaseAABB((Object)("FanAirBox" + String.valueOf(efbe)), bounds).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(airCurrent.maxDistance);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            double offsetDistance = (double)airCurrent.maxDistance * offset;
            Direction.Axis axis = airCurrent.direction.getAxis();
            double min = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> bounds.minX;
                case Direction.Axis.Y -> bounds.minY;
                case Direction.Axis.Z -> bounds.minZ;
            };
            double max = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> bounds.maxX;
                case Direction.Axis.Y -> bounds.maxY;
                case Direction.Axis.Z -> bounds.maxZ;
            };
            double pos = airCurrent.pushing == airCurrent.direction.getAxisDirection().getStep() > 0 ? min + offsetDistance : max - offsetDistance;
            AABB flowBound = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> new AABB(pos, bounds.minY, bounds.minZ, pos, bounds.maxY, bounds.maxZ);
                case Direction.Axis.Y -> new AABB(bounds.minX, pos, bounds.minZ, bounds.maxX, pos, bounds.maxZ);
                case Direction.Axis.Z -> new AABB(bounds.minX, bounds.minY, pos, bounds.maxX, bounds.maxY, pos);
            };
            String id = "FanAirFlowBox" + String.valueOf(efbe) + i;
            if (offset > 0.98) {
                Outliner.getInstance().remove((Object)id);
                continue;
            }
            Outliner.getInstance().chaseAABB((Object)id, flowBound).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static void render(@NotNull NozzleBlockEntity nbe) {
        Vec3 center = VecHelper.getCenterOf((Vec3i)nbe.getBlockPos());
        int color = DelayRender.getColor(nbe.pushing);
        Outliner.getInstance().chaseAABB((Object)("NozzleAirBox" + String.valueOf(nbe)), new AABB(center, center).inflate((double)(nbe.range / 2.0f))).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(nbe.range);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            String id = "NozzleAirFlowBox" + String.valueOf(nbe) + i;
            if (offset > 0.98) {
                Outliner.getInstance().remove((Object)id);
                continue;
            }
            double radius = nbe.pushing ? offset * (double)nbe.range / 2.0 : (1.0 - offset) * (double)nbe.range / 2.0;
            AABB flowBound = new AABB(center, center).inflate(radius);
            Outliner.getInstance().chaseAABB((Object)id, flowBound).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static int getColor(boolean pushing) {
        return pushing ? CCG.CONFIG.delayRender.airBoxPushColor : CCG.CONFIG.delayRender.airBoxPullColor;
    }

    public static double getOffset(int i, int numberOfFlowBoxes) {
        return ((double)System.currentTimeMillis() + (double)i * (3000.0 / (double)numberOfFlowBoxes)) % 3000.0 / 3000.0;
    }

    public static int getNumberOfFlowBoxes(float range) {
        return (int)(Math.log(range) + 1.0);
    }

    public static void render(@NotNull ArmBlockEntity abe) {
        DelayRender.drawArmIO(abe, abe.inputs);
        DelayRender.drawArmIO(abe, abe.outputs);
    }

    public static void drawArmIO(@NotNull ArmBlockEntity abe, List<ArmInteractionPoint> list) {
        list.forEach(point -> {
            if (!point.isValid()) {
                list.remove(point);
                return;
            }
            Level level = point.getLevel();
            BlockPos pos = point.getPos();
            Outliner.getInstance().chaseAABB((Object)("ArmIOBox" + String.valueOf(point)), level.getBlockState(pos).getShape((BlockGetter)level, pos).bounds().move(pos)).withFaceTextures((BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(point.getMode().getColor());
            Outliner.getInstance().showLine((Object)("ArmIOLine" + String.valueOf(point)), abe.getBlockPos().getCenter(), point.getPos().getCenter()).lineWidth(0.125f).colored(point.getMode().getColor());
        });
    }

    public static void render(@NotNull EjectorBlockEntity ebe) {
        Outliner.getInstance().chaseAABB((Object)("EjectorTargetBox" + String.valueOf(ebe)), new AABB(ebe.getTargetPosition())).lineWidth(0.0625f).colored(CCG.CONFIG.delayRender.airBoxPushColor);
    }
}

