/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.misc;

import com.simibubi.create.compat.jei.category.SequencedAssemblyCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.forgestove.create_cyber_goggles.CCG;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SequencedAssemblyCategory.class})
public abstract class SequencedAssemblyCategoryMixin {
    @Inject(method={"setRecipe*"}, at={@At(value="TAIL")})
    private void setRecipe(IRecipeLayoutBuilder builder, SequencedAssemblyRecipe recipe, IFocusGroup focuses, CallbackInfo callbackInfo) {
        if (!CCG.CONFIG.misc.showScrapContent) {
            return;
        }
        int size = 8;
        for (int i = 1; i < recipe.resultPool.size(); ++i) {
            ProcessingOutput out = (ProcessingOutput)recipe.resultPool.get(i);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, (i - 1) % size * 19 + 15, (i - 1) / size * 19 + 120).setBackground(new IDrawable(this){

                public int getWidth() {
                    return AllGuiTextures.JEI_CHANCE_SLOT.getWidth();
                }

                public int getHeight() {
                    return AllGuiTextures.JEI_CHANCE_SLOT.getHeight();
                }

                public void draw(@NotNull GuiGraphics guiGraphics, int xOffset, int yOffset) {
                    AllGuiTextures.JEI_CHANCE_SLOT.render(guiGraphics, xOffset, yOffset);
                }
            }, -1, -1).addItemStack(out.getStack())).addRichTooltipCallback((iRecipeSlotView, iTooltipBuilder) -> {
                float totalWeight = 0.0f;
                for (ProcessingOutput output : recipe.resultPool) {
                    totalWeight += output.getChance();
                }
                iTooltipBuilder.add((FormattedText)this.chanceComponent(out.getChance() / totalWeight));
            });
        }
    }

    @Shadow
    protected abstract MutableComponent chanceComponent(float var1);

    @Inject(method={"chanceComponent"}, at={@At(value="HEAD")}, cancellable=true)
    protected void chanceComponent(float chance, CallbackInfoReturnable<MutableComponent> returnable) {
        if (!CCG.CONFIG.goggles.preciseNumber) {
            return;
        }
        if (chance * 100.0f == (float)((int)(chance * 100.0f))) {
            return;
        }
        returnable.setReturnValue((Object)CreateLang.translateDirect((String)"recipe.processing.chance", (Object[])new Object[]{Float.valueOf(chance * 100.0f)}).withStyle(ChatFormatting.GOLD));
    }
}

