/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.jetbrains.annotations.NotNull;

public class KineticDebugger {
    public static BlockPos lastSource;
    public static List<KineticBlockEntity> cachedKBEPath;

    public static void tick(ClientTickEvent.Post ignoredEvent) {
        if (!CCG.CONFIG.outlineRenderer.rainbowDebug) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused() || mc.screen != null || mc.level == null) {
            return;
        }
        KineticBlockEntity kbe = CCGUtil.getKBE();
        if (kbe == null) {
            return;
        }
        KineticDebugger.renderAxisLine(kbe);
        KineticDebugger.updateKBEPath(mc.level, kbe);
        KineticDebugger.renderKineticPath(mc.level, cachedKBEPath, mc.level.getGameTime());
    }

    public static void updateKBEPath(ClientLevel level, @NotNull KineticBlockEntity kbe) {
        if (kbe.source == lastSource && cachedKBEPath != null) {
            return;
        }
        ArrayDeque<KineticBlockEntity> kbePath = new ArrayDeque<KineticBlockEntity>();
        KineticBlockEntity currentBE = kbe;
        while (currentBE != null) {
            KineticBlockEntity kbeSource;
            kbePath.addFirst(currentBE);
            if (currentBE.source == null) break;
            BlockEntity blockEntity = level.getBlockEntity(currentBE.source);
            currentBE = blockEntity instanceof KineticBlockEntity ? (kbeSource = (KineticBlockEntity)blockEntity) : null;
        }
        cachedKBEPath = List.copyOf(kbePath);
        lastSource = kbe.source;
    }

    public static void renderKineticPath(ClientLevel level, @NotNull List<KineticBlockEntity> kbePath, long time) {
        Frustum frustum = Minecraft.getInstance().levelRenderer.getFrustum();
        for (int depth = 0; depth < kbePath.size(); ++depth) {
            KineticBlockEntity nodeBE = kbePath.get(depth);
            int rgb = KineticDebugger.getRainbowColor(depth, time);
            if (KineticDebugger.isAABBInFrustum(nodeBE, level, frustum)) {
                KineticDebugger.renderOutline(nodeBE, depth, rgb);
            }
            if (nodeBE.source == null || !KineticDebugger.isLineInFrustum((Vec3i)nodeBE.getBlockPos(), (Vec3i)nodeBE.source, frustum)) continue;
            KineticDebugger.renderKineticLine(nodeBE, depth, rgb);
        }
    }

    public static boolean isAABBInFrustum(@NotNull KineticBlockEntity kbe, @NotNull ClientLevel level, Frustum frustum) {
        BlockPos pos = kbe.getBlockPos();
        VoxelShape shape = level.getBlockState(pos).getBlockSupportShape((BlockGetter)level, pos);
        if (shape.isEmpty()) {
            return false;
        }
        return frustum.isVisible(shape.bounds().move(pos));
    }

    public static boolean isLineInFrustum(Vec3i start, Vec3i end, @NotNull Frustum frustum) {
        return frustum.isVisible(new AABB(VecHelper.getCenterOf((Vec3i)start), VecHelper.getCenterOf((Vec3i)end)));
    }

    public static void renderOutline(@NotNull KineticBlockEntity kbe, int depth, int rgb) {
        if (kbe.getTheoreticalSpeed() == 0.0f) {
            return;
        }
        BlockPos blockPos = kbe.getBlockPos();
        AABB bounds = CCGUtil.getBounds(blockPos);
        if (bounds == null) {
            return;
        }
        Outliner.getInstance().chaseAABB((Object)("KineticOutline" + depth), bounds).lineWidth(0.0625f).colored(rgb);
    }

    public static int getRainbowColor(int depth, long time) {
        return Color.HSBtoRGB(1.0f - ((float)depth * 0.05f - (float)(time % 50L) / 50.0f) % 1.0f, 0.8f, 1.0f);
    }

    public static void renderKineticLine(@NotNull KineticBlockEntity kbe, int depth, int rgb) {
        BlockPos end;
        if (kbe.source == null) {
            return;
        }
        BlockPos start = kbe.getBlockPos();
        if (start.distManhattan((Vec3i)(end = kbe.source)) == 1) {
            return;
        }
        Outliner.getInstance().showLine((Object)("KineticLine" + depth), VecHelper.getCenterOf((Vec3i)start), VecHelper.getCenterOf((Vec3i)end)).lineWidth(0.125f).colored(rgb);
    }

    public static void renderAxisLine(@NotNull KineticBlockEntity kbe) {
        BlockState state = kbe.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof IRotate)) {
            return;
        }
        IRotate iRotate = (IRotate)block;
        Vec3 vec = Vec3.atLowerCornerOf((Vec3i)Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)iRotate.getRotationAxis(state)).getNormal());
        Vec3 center = VecHelper.getCenterOf((Vec3i)kbe.getBlockPos());
        Outliner.getInstance().showLine((Object)"RotationAxis", center.add(vec), center.subtract(vec)).lineWidth(0.125f);
    }
}

