/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.foundation.utility.Lang;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

public class ItemTooltip {
    public static void itemTooltip(@NotNull ItemTooltipEvent event) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        ItemTooltip.goggles(stack, tooltip);
        ItemTooltip.backtank(stack, tooltip);
        ItemTooltip.divingBoots(stack, tooltip);
        ItemTooltip.wrench(stack, tooltip);
        ItemTooltip.toolbox(stack, tooltip);
    }

    private static void goggles(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!(stack.m_41720_() instanceof GogglesItem)) {
            return;
        }
        MutableComponent component = CCGLang.enabled(GogglesItem.isWearingGoggles((Player)CCGUtil.mc.f_91074_)).component();
        tooltip.add(1, (Component)component);
    }

    private static void backtank(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!(stack.m_41720_() instanceof BacktankItem)) {
            return;
        }
        MutableComponent component = Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).add(CCGLang.fraction((int)BacktankUtil.getAir((ItemStack)stack), BacktankUtil.maxAir((ItemStack)stack))).component();
        tooltip.add(1, (Component)component);
    }

    private static void divingBoots(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!(stack.m_41720_() instanceof DivingBootsItem)) {
            return;
        }
        MutableComponent component = CCGLang.enabled(CCG.CONFIG.misc.allowDivingBoot).component();
        tooltip.add(1, (Component)component);
    }

    private static void wrench(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!(stack.m_41720_() instanceof WrenchItem)) {
            return;
        }
        MutableComponent component = CCGLang.configBuilder().translate("option.wrench.leftClickFastDismantle", new Object[0]).space().add(CCGLang.enabled(CCG.CONFIG.wrench.leftClickFastDismantle)).component();
        tooltip.add(1, (Component)component);
    }

    private static void toolbox(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!AllTags.AllItemTags.TOOLBOXES.matches(stack)) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("Inventory")) {
            return;
        }
        ArrayList list = new ArrayList();
        CompoundTag inventory = tag.m_128469_("Inventory");
        if (!inventory.m_128441_("Items")) {
            return;
        }
        ListTag items = inventory.m_128437_("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag slotTag = items.m_128728_(i);
            ItemStack slotStack = ItemStack.m_41712_((CompoundTag)slotTag);
            if (slotStack.m_41619_()) continue;
            CCGLang.item(slotStack).addTo(list);
        }
        tooltip.addAll(1, list);
    }
}

