/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;

public class KineticDebugger {
    public static BlockPos lastSource;
    public static List<KineticBlockEntity> cachedKBEPath;

    public static void tick(TickEvent.ClientTickEvent ignoredEvent) {
        if (!CCG.CONFIG.outlineRenderer.rainbowDebug) {
            return;
        }
        if (CCGUtil.mc.m_91104_() || CCGUtil.isInGUI() || CCGUtil.mc.f_91073_ == null) {
            return;
        }
        KineticBlockEntity kbe = CCGUtil.getBlockEntity(KineticBlockEntity.class);
        if (kbe == null) {
            return;
        }
        KineticDebugger.renderAxisLine(kbe);
        KineticDebugger.updateKBEPath(CCGUtil.mc.f_91073_, kbe);
        KineticDebugger.renderKineticPath(cachedKBEPath, CCGUtil.mc.f_91073_.m_46467_());
    }

    public static void updateKBEPath(ClientLevel level, @NotNull KineticBlockEntity kbe) {
        if (kbe.source == lastSource && cachedKBEPath != null) {
            return;
        }
        ArrayDeque<KineticBlockEntity> kbePath = new ArrayDeque<KineticBlockEntity>();
        KineticBlockEntity currentBE = kbe;
        while (currentBE != null) {
            KineticBlockEntity kbeSource;
            kbePath.addFirst(currentBE);
            if (currentBE.source == null) break;
            BlockEntity blockEntity = level.m_7702_(currentBE.source);
            currentBE = blockEntity instanceof KineticBlockEntity ? (kbeSource = (KineticBlockEntity)blockEntity) : null;
        }
        cachedKBEPath = List.copyOf(kbePath);
        lastSource = kbe.source;
    }

    public static void renderKineticPath(@NotNull List<KineticBlockEntity> kbePath, long time) {
        Frustum frustum = CCGUtil.mc.f_91060_.getFrustum();
        for (int depth = 0; depth < kbePath.size(); ++depth) {
            KineticBlockEntity nodeBE = kbePath.get(depth);
            int rgb = KineticDebugger.getRainbowColor(depth, time);
            if (KineticDebugger.isAABBInFrustum(nodeBE, frustum)) {
                KineticDebugger.renderOutline(nodeBE, depth, rgb);
            }
            if (nodeBE.source == null || !KineticDebugger.isLineInFrustum((Vec3i)nodeBE.m_58899_(), (Vec3i)nodeBE.source, frustum)) continue;
            KineticDebugger.renderKineticLine(nodeBE, depth, rgb);
        }
    }

    public static boolean isAABBInFrustum(@NotNull KineticBlockEntity kbe, Frustum frustum) {
        if (CCGUtil.mc.f_91073_ == null) {
            return false;
        }
        BlockPos pos = kbe.m_58899_();
        VoxelShape shape = CCGUtil.mc.f_91073_.m_8055_(pos).m_60816_((BlockGetter)CCGUtil.mc.f_91073_, pos);
        if (shape.m_83281_()) {
            return false;
        }
        return frustum.m_113029_(shape.m_83215_().m_82338_(pos));
    }

    public static boolean isLineInFrustum(Vec3i start, Vec3i end, @NotNull Frustum frustum) {
        return frustum.m_113029_(new AABB(VecHelper.getCenterOf((Vec3i)start), VecHelper.getCenterOf((Vec3i)end)));
    }

    public static void renderOutline(@NotNull KineticBlockEntity kbe, int depth, int rgb) {
        if (kbe.getTheoreticalSpeed() == 0.0f) {
            return;
        }
        BlockPos blockPos = kbe.m_58899_();
        CreateClient.OUTLINER.chaseAABB((Object)("KineticOutline" + depth), CCGUtil.getBounds(blockPos)).lineWidth(0.0625f).colored(rgb);
    }

    public static int getRainbowColor(int depth, long time) {
        return Color.HSBtoRGB(1.0f - ((float)depth * 0.05f - (float)(time % 50L) / 50.0f) % 1.0f, 0.8f, 1.0f);
    }

    public static void renderKineticLine(@NotNull KineticBlockEntity kbe, int depth, int rgb) {
        BlockPos end;
        if (kbe.source == null) {
            return;
        }
        BlockPos start = kbe.m_58899_();
        if (start.m_123333_((Vec3i)(end = kbe.source)) == 1) {
            return;
        }
        CreateClient.OUTLINER.showLine((Object)("KineticLine" + depth), VecHelper.getCenterOf((Vec3i)start), VecHelper.getCenterOf((Vec3i)end)).lineWidth(0.125f).colored(rgb);
    }

    public static void renderAxisLine(@NotNull KineticBlockEntity kbe) {
        BlockState state = kbe.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof IRotate)) {
            return;
        }
        IRotate iRotate = (IRotate)block;
        Vec3 vec = Vec3.m_82528_((Vec3i)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)iRotate.getRotationAxis(state)).m_122436_());
        Vec3 center = VecHelper.getCenterOf((Vec3i)kbe.m_58899_());
        CreateClient.OUTLINER.showLine((Object)"RotationAxis", center.m_82549_(vec), center.m_82546_(vec)).lineWidth(0.125f);
    }
}

