/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCGUtil {
    public static final Minecraft mc = Minecraft.m_91087_();

    @Contract(pure=true)
    public static boolean isInGUI() {
        return CCGUtil.mc.f_91080_ != null;
    }

    @Contract(pure=true)
    public static boolean isInGame() {
        return !CCGUtil.isInGUI();
    }

    public static boolean isClient() {
        return EffectiveSide.get().isClient();
    }

    public static boolean isServer() {
        return !CCGUtil.isClient();
    }

    @Nullable
    public static <T extends U, U> T getAs(@NotNull Class<T> clazz, U object) {
        return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
    }

    @Contract(pure=true)
    @Nullable
    public static BlockHitResult getBlockHitResult() {
        BlockHitResult result;
        HitResult hitResult = CCGUtil.mc.f_91077_;
        return hitResult instanceof BlockHitResult ? ((result = (BlockHitResult)hitResult).m_6662_() != HitResult.Type.MISS ? result : null) : null;
    }

    @Contract(pure=true)
    @Nullable
    public static EntityHitResult getEntityHitResult() {
        EntityHitResult result;
        HitResult hitResult = CCGUtil.mc.f_91077_;
        return hitResult instanceof EntityHitResult ? (result = (EntityHitResult)hitResult) : null;
    }

    @Nullable
    public static BlockEntity getBlockEntity() {
        if (CCGUtil.mc.f_91073_ == null) {
            return null;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null || result.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        return CCGUtil.mc.f_91073_.m_7702_(result.m_82425_());
    }

    public static <T extends BlockEntity> T getBlockEntity(Class<T> clazz) {
        return (T)((BlockEntity)CCGUtil.getAs(clazz, CCGUtil.getBlockEntity()));
    }

    @Nullable
    public static Block getBlock() {
        if (CCGUtil.mc.f_91073_ == null) {
            return null;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null || result.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        return CCGUtil.mc.f_91073_.m_8055_(result.m_82425_()).m_60734_();
    }

    @Nullable
    public static Entity getEntity() {
        EntityHitResult result = CCGUtil.getEntityHitResult();
        return result != null ? result.m_82443_() : null;
    }

    @Nullable
    public static ItemStack getRelevantFilterItem() {
        if (CCGUtil.isInGUI()) {
            Screen screen = CCGUtil.mc.f_91080_;
            if (!(screen instanceof AbstractContainerScreen)) {
                return null;
            }
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot slot = screen2.getSlotUnderMouse();
            return slot == null ? null : slot.m_7993_();
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        SmartBlockEntity sbe = CCGUtil.getBlockEntity(SmartBlockEntity.class);
        if (sbe == null || result == null) {
            return null;
        }
        FilteringBehaviour behaviour = (FilteringBehaviour)sbe.getBehaviour(FilteringBehaviour.TYPE);
        return behaviour == null ? ItemStack.f_41583_ : behaviour.getFilter(result.m_82434_());
    }

    @NotNull
    public static AABB getBounds(BlockPos blockPos) {
        if (CCGUtil.mc.f_91073_ == null) {
            return Shapes.m_83144_().m_83215_();
        }
        VoxelShape shape = CCGUtil.mc.f_91073_.m_8055_(blockPos).m_60808_((BlockGetter)CCGUtil.mc.f_91073_, blockPos);
        return (shape.m_83281_() ? Shapes.m_83144_() : shape).m_83215_().m_82338_(blockPos);
    }

    @Contract(pure=true)
    public static int getGradientColor(float progress) {
        return Color.HSBtoRGB(progress * 0.33f, 1.0f, 1.0f);
    }

    public static void playSound(SoundEvent sound, float pitch, float volume) {
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void toggleConfig(boolean keyDown, boolean enabled, Consumer<Boolean> setter, String messageKey) {
        if (!keyDown) {
            return;
        }
        if (CCGUtil.isInGUI()) {
            return;
        }
        boolean newEnabled = !enabled;
        setter.accept(newEnabled);
        if (CCGUtil.mc.f_91074_ == null) {
            return;
        }
        CCGLang.translate(messageKey, new Object[0]).space().add(CCGLang.enabled(newEnabled)).style(enabled ? ChatFormatting.RED : ChatFormatting.GREEN).sendStatus((Player)CCGUtil.mc.f_91074_);
    }

    public static void sendAction(ServerboundPlayerCommandPacket.Action action) {
        if (CCGUtil.mc.f_91074_ == null) {
            return;
        }
        CCGUtil.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerCommandPacket((Entity)CCGUtil.mc.f_91074_, action));
    }
}

