/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGLang;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class Common {
    public static void renderItemStack(GuiGraphics guiGraphics, ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        TooltipFlag.Default tooltipFlag = mc.f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_;
        List tooltipLines = itemStack.m_41651_((Player)mc.f_91074_, (TooltipFlag)tooltipFlag);
        int n = tooltipLines.size();
        Objects.requireNonNull(font);
        int height = Math.max(10, n * 9 - 60);
        int x = guiGraphics.m_280182_() / 2 + (Integer)AllConfigs.client().overlayOffsetX.get();
        int y = guiGraphics.m_280206_() / 2 + (Integer)AllConfigs.client().overlayOffsetY.get();
        guiGraphics.m_280480_(itemStack, x + 10, y - 16);
        guiGraphics.m_280370_(font, itemStack, x + 10, y - 16);
        guiGraphics.m_280153_(font, itemStack, x + 22, y - height);
    }

    @Nullable
    public static KineticBlockEntity getKBE() {
        BlockEntity blockEntity = Common.getBE();
        if (!(blockEntity instanceof KineticBlockEntity)) {
            return null;
        }
        KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
        return kbe;
    }

    @Nullable
    public static BlockEntity getBE() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        return mc.f_91073_.m_7702_(blockHitResult.m_82425_());
    }

    public static boolean addFanTooltip(List<Component> tooltip, boolean pushing, float range, int divide) {
        if (range == 0.0f) {
            return false;
        }
        CCGLang.translate("tooltip.windState", new Object[0]).forGoggles(tooltip);
        CCGLang.number(range / (float)divide).space().translate(pushing ? "tooltip.pushRange" : "tooltip.pullRange", new Object[0]).color(pushing ? CCG.CONFIG.delayRender.windPushColor : CCG.CONFIG.delayRender.windPullColor).forGoggles(tooltip);
        return true;
    }

    public static boolean addBurnerTooltip(List<Component> tooltip, int remainingBurnTime, boolean isCreative, BlazeBurnerBlockEntity.FuelType activeFuel) {
        CCGLang.translate("tooltip.burnerState", new Object[0]).forGoggles(tooltip);
        LangBuilder langBuilder = CCGLang.text(isCreative ? "\u221e" : String.format("%.2f", Float.valueOf((float)remainingBurnTime / 20.0f))).text(String.format(" / %d ", 500)).translate("tooltip.seconds", new Object[0]);
        langBuilder.style(switch (activeFuel) {
            case BlazeBurnerBlockEntity.FuelType.SPECIAL -> ChatFormatting.AQUA;
            case BlazeBurnerBlockEntity.FuelType.NORMAL -> ChatFormatting.YELLOW;
            default -> ChatFormatting.GRAY;
        }).forGoggles(tooltip);
        return true;
    }

    @Nullable
    public static ItemStack getRelevantFilterItem() {
        SmartBlockEntity sbe;
        BlockEntity blockEntity;
        block6: {
            block5: {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91080_ != null) {
                    Screen screen = mc.f_91080_;
                    if (!(screen instanceof AbstractContainerScreen)) {
                        return null;
                    }
                    AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                    Slot slot = screen2.getSlotUnderMouse();
                    return slot == null ? null : slot.m_7993_();
                }
                blockEntity = Common.getBE();
                if (!(blockEntity instanceof SmartBlockEntity)) break block5;
                sbe = (SmartBlockEntity)blockEntity;
                blockEntity = mc.f_91077_;
                if (blockEntity instanceof BlockHitResult) break block6;
            }
            return null;
        }
        BlockHitResult blockHitResult = (BlockHitResult)blockEntity;
        FilteringBehaviour behaviour = (FilteringBehaviour)sbe.getBehaviour(FilteringBehaviour.TYPE);
        return behaviour == null ? null : behaviour.getFilter(blockHitResult.m_82434_());
    }

    public static void displayMessage(LangBuilder builder) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_5661_((Component)builder.component(), true);
        }
    }

    public static void playSound(SoundEvent sound, float pitch, float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void playSound(AllSoundEvents.SoundEntry entry) {
        Common.playSound(entry.getMainEvent(), 0.25f, 1.0f);
    }

    public static void playSound(SoundEvent sound) {
        Common.playSound(sound, 1.0f, 1.0f);
    }
}

