/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.goggles;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GeneratingKineticBlockEntity.class}, remap=false)
public abstract class GeneratingKineticBlockEntityMixin
extends KineticBlockEntity {
    public GeneratingKineticBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Inject(method={"addToGoggleTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    public void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> returnable) {
        CCGConfig.Goggles goggles = CCG.CONFIG.goggles;
        if (!goggles.enhancedInfo) {
            return;
        }
        float speed = this.getTheoreticalSpeed();
        if (goggles.hideStaticKineticInfo && speed == 0.0f) {
            returnable.setReturnValue((Object)false);
            return;
        }
        float stressBase = this.calculateAddedStressCapacity();
        if (!Mth.m_14033_((float)stressBase, (float)0.0f)) {
            Lang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            if (speed != this.getGeneratedSpeed()) {
                stressBase *= this.getGeneratedSpeed() / speed;
            }
            Lang.number((double)Math.abs(stressBase * speed)).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip);
        }
        returnable.setReturnValue((Object)super.addToGoggleTooltip(tooltip, isPlayerSneaking));
    }
}

