/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeStove.create_cyber_goggles.event;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import org.lwjgl.glfw.GLFW;

public enum KeyBinds {
    FILTER_MENU("filterMenu", 342, "Focus Filter Menu");

    private final String description;
    private final String translation;
    private final int key;
    private final boolean modifiable;
    private KeyMapping keyMapping;

    private KeyBinds(String description, int defaultKey, String translation) {
        this.description = "create_cyber_goggles.keyInfo." + description;
        this.key = defaultKey;
        this.modifiable = !description.isEmpty();
        this.translation = translation;
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (KeyBinds keyBinds : KeyBinds.values()) {
            if (!keyBinds.modifiable) continue;
            consumer.accept(keyBinds.description, keyBinds.translation);
        }
    }

    public static void register(RegisterKeyMappingsEvent event) {
        for (KeyBinds keyBinds : KeyBinds.values()) {
            keyBinds.keyMapping = new KeyMapping(keyBinds.description, keyBinds.key, "Create: Cyber Goggles");
            if (!keyBinds.modifiable) continue;
            event.register(keyBinds.keyMapping);
        }
    }

    public static boolean isMouseButtonDown(int button) {
        return GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)button) == 1;
    }

    public KeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    public boolean isPressed() {
        if (!this.modifiable) {
            return KeyBinds.isKeyDown(this.key);
        }
        return this.keyMapping.isDown();
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)key);
    }

    public String getBoundKey() {
        return this.keyMapping.getTranslatedKeyMessage().getString().toUpperCase();
    }

    public int getBoundCode() {
        return this.keyMapping.getKey().getValue();
    }
}

