/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.RotationPropagatorAccessor;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.jetbrains.annotations.NotNull;

public class KineticParticle {
    public static void tick(ClientTickEvent.Post ignoredEvent) {
        if (!CCG.CONFIG.goggles.enableKineticEffect || CCGUtil.mc.level == null || CCGUtil.isInGUI()) {
            return;
        }
        KineticBlockEntity kbe = CCGUtil.getBlockEntity(KineticBlockEntity.class);
        if (kbe == null) {
            return;
        }
        float kbeSpeed = kbe.getSpeed();
        if (kbeSpeed == 0.0f) {
            return;
        }
        BlockState state = kbe.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof KineticBlock)) {
            return;
        }
        KineticBlock kb = (KineticBlock)block;
        Vec3 center = VecHelper.getCenterOf((Vec3i)kbe.getBlockPos());
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of((float)kbeSpeed);
        float particleSpeed = (float)Math.max(15, speedLevel.getParticleSpeed()) * Math.signum(kbeSpeed);
        if (KineticParticle.renderShaftParticles(kbe, kb, state, center, speedLevel.getColor(), particleSpeed)) {
            return;
        }
        if (kb instanceof BeltBlock) {
            return;
        }
        KineticParticle.renderDefaultParticles(kb, state, center, speedLevel.getColor(), particleSpeed);
    }

    private static boolean renderShaftParticles(KineticBlockEntity kbe, KineticBlock kb, BlockState state, Vec3 center, int color, float particleSpeed) {
        boolean hasRendered = false;
        for (Direction direction : Direction.values()) {
            if (!kb.hasShaftTowards((LevelReader)CCGUtil.mc.level, kbe.getBlockPos(), state, direction)) continue;
            Direction.Axis axis = direction.getAxis();
            float directionSpeed = particleSpeed * RotationPropagatorAccessor.getAxisModifier(kbe, direction);
            double offset = 0.5 * (double)direction.getAxisDirection().getStep();
            Vec3 axisVec = new Vec3(axis == Direction.Axis.X ? offset : 0.0, axis == Direction.Axis.Y ? offset : 0.0, axis == Direction.Axis.Z ? offset : 0.0);
            Vec3 pos = center.add(axisVec);
            float initial = Mth.clamp((float)(kb.getParticleInitialRadius() / 2.0f), (float)0.1f, (float)0.3f);
            float target = Mth.clamp((float)(kb.getParticleTargetRadius() / 2.0f), (float)0.2f, (float)0.4f);
            RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, directionSpeed, initial, target, 10, axis);
            KineticParticle.spawnParticles(particleData, pos);
            hasRendered = true;
        }
        if (kb instanceof EncasedCogwheelBlock) {
            return false;
        }
        return hasRendered;
    }

    private static void renderDefaultParticles(@NotNull KineticBlock kb, BlockState state, Vec3 center, int color, float particleSpeed) {
        float initial = kb.getParticleInitialRadius();
        float target = kb.getParticleTargetRadius();
        RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, initial, target, 10, kb.getRotationAxis(state));
        KineticParticle.spawnParticles(particleData, center);
    }

    private static void spawnParticles(RotationIndicatorParticleData particleData, Vec3 pos) {
        if (CCGUtil.mc.level == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            CCGUtil.mc.level.addParticle((ParticleOptions)particleData, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
        }
    }
}

