/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.IItemRenderable;
import java.util.List;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;

public class OverlayRenderer {
    public static int hoverTicks;
    public static float fade;
    @NotNull
    public static ItemStack currentItemStack;

    public static void register(@NotNull RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"create_cyber_goggles", (String)"item_tooltip_overlay"), OverlayRenderer::renderOverlay);
    }

    public static void color(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderTooltipEvent.Color event) {
        Color colorBackground;
        if (currentItemStack != event.getItemStack() || currentItemStack.isEmpty()) {
            return;
        }
        Color color = colorBackground = (Boolean)AllConfigs.client().overlayCustomColor.get() != false ? new Color(((Integer)AllConfigs.client().overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
        if (fade < 1.0f) {
            colorBackground.scaleAlpha(fade);
        }
        event.setBackground(colorBackground.getRGB());
    }

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!CCG.CONFIG.goggles.renderExtraItems || !CCG.CONFIG.gameMode.enableGoggle) {
            return;
        }
        if (CCGUtil.mc.isPaused() || CCGUtil.isInGUI() || CCGUtil.mc.options.hideGui) {
            currentItemStack = ItemStack.EMPTY;
            hoverTicks = 0;
            return;
        }
        if (!CCG.CONFIG.goggles.canRenderOnValueBox && CCGUtil.hasActivedValueBox()) {
            return;
        }
        fade = Mth.clamp((float)(((float)hoverTicks++ + deltaTracker.getGameTimeDeltaPartialTick(false)) / 24.0f), (float)0.0f, (float)1.0f);
        currentItemStack = OverlayRenderer.toRenderItemStack();
        if (currentItemStack.isEmpty()) {
            hoverTicks = 0;
        } else {
            OverlayRenderer.renderItemStack(guiGraphics, currentItemStack);
        }
    }

    @NotNull
    public static ItemStack toRenderItemStack() {
        try {
            BlockEntity blockEntity = CCGUtil.getBlockEntity();
            if (blockEntity instanceof IItemRenderable) {
                IItemRenderable renderable = (IItemRenderable)blockEntity;
                return CCGUtil.orEmpty(renderable.ccg$getItemStack());
            }
            blockEntity = CCGUtil.getEntity();
            if (blockEntity instanceof IItemRenderable) {
                IItemRenderable renderable = (IItemRenderable)blockEntity;
                return CCGUtil.orEmpty(renderable.ccg$getItemStack());
            }
        }
        catch (Exception exception) {
            CCG.LOGGER.error("Failed to get item stack from IItemRenderable", (Throwable)exception);
        }
        return ItemStack.EMPTY;
    }

    public static void renderItemStack(GuiGraphics guiGraphics, @NotNull ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return;
        }
        TooltipFlag.Default flag = new TooltipFlag.Default(CCGUtil.mc.options.advancedItemTooltips, true);
        List tooltip = itemStack.getTooltipLines(Item.TooltipContext.of((Level)CCGUtil.mc.level), (Player)CCGUtil.mc.player, (TooltipFlag)flag);
        int tooltipTextWidth = tooltip.stream().mapToInt(arg_0 -> ((Font)CCGUtil.mc.font).width(arg_0)).max().orElse(0) + 24;
        int x = guiGraphics.guiWidth() / 2 + (Integer)AllConfigs.client().overlayOffsetX.get() + CCG.CONFIG.goggles.overlayOffsetX;
        int y = guiGraphics.guiHeight() / 2 + (Integer)AllConfigs.client().overlayOffsetY.get() + CCG.CONFIG.goggles.overlayOffsetY;
        if (x + tooltipTextWidth > guiGraphics.guiWidth()) {
            x = guiGraphics.guiWidth() - tooltipTextWidth;
        }
        if (fade < 1.0f) {
            x += (int)(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)AllConfigs.client().overlayOffsetX.get()).intValue() + 0.5f) * 8.0);
        }
        if (GoggleOverlayRenderer.hoverTicks != 0) {
            y -= (tooltip.size() + 1) * 10;
        }
        x = Math.max(16, x);
        y = Math.max(16, y);
        int itemX = x - 10;
        int itemY = y - 10;
        guiGraphics.renderItem(itemStack, itemX, itemY);
        guiGraphics.renderItemDecorations(CCGUtil.mc.font, itemStack, itemX, itemY);
        guiGraphics.renderTooltip(CCGUtil.mc.font, itemStack, x, y);
    }

    static {
        currentItemStack = ItemStack.EMPTY;
    }
}

