/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.goggles;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import io.github.forgestove.create_cyber_goggles.CCG;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DeployerBlockEntity.class}, remap=false)
public abstract class DeployerBlockEntityMixin
extends KineticBlockEntity {
    @Shadow
    protected List<ItemStack> overflowItems;

    public DeployerBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Inject(method={"addToTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    public void addToTooltip(List<Component> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> returnable) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        super.addToTooltip(tooltip, isPlayerSneaking);
        if (this.overflowItems.isEmpty()) {
            returnable.setReturnValue((Object)false);
            return;
        }
        TooltipHelper.addHint(tooltip, (String)"hint.full_deployer", (Object[])new Object[0]);
        for (ItemStack itemStack : this.overflowItems) {
            Lang.builder().add(Component.m_237115_((String)itemStack.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(Lang.text((String)(" x" + itemStack.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip);
        }
        returnable.setReturnValue((Object)true);
    }

    @Inject(method={"addToGoggleTooltip"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/deployer/DeployerBlockEntity;calculateStressApplied()F")}, cancellable=true)
    public void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> returnable) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        returnable.setReturnValue((Object)super.addToGoggleTooltip(tooltip, isPlayerSneaking));
    }
}

