/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.event;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.kinetics.fan.NozzleBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.Common;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.ArmBlockEntityAccessor;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.NozzleBlockEntityAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class DelayRender {
    public static Object2IntOpenHashMap<class_2586> cachedBE = new Object2IntOpenHashMap();

    public static void tick(class_310 mc) {
        if (!CCG.CONFIG.delayRender.renderAnalogBox) {
            return;
        }
        if (mc.field_1687 == null) {
            cachedBE.clear();
            return;
        }
        if (mc.method_1493() || mc.field_1755 != null) {
            return;
        }
        class_2586 be = Common.getSelectedBE();
        if (be instanceof EncasedFanBlockEntity || be instanceof NozzleBlockEntity || be instanceof ArmBlockEntity || be instanceof EjectorBlockEntity) {
            cachedBE.put((Object)be, CCG.CONFIG.delayRender.delayRenderDuration);
        }
        if (cachedBE.isEmpty()) {
            return;
        }
        cachedBE.object2IntEntrySet().removeIf(entry -> {
            class_2586 blockEntity = (class_2586)entry.getKey();
            int newValue = entry.getIntValue() - 1;
            entry.setValue(newValue);
            if (!blockEntity.method_11015()) {
                if (blockEntity instanceof EncasedFanBlockEntity) {
                    EncasedFanBlockEntity efbe = (EncasedFanBlockEntity)blockEntity;
                    DelayRender.render(efbe);
                } else if (blockEntity instanceof NozzleBlockEntity) {
                    NozzleBlockEntity nbe = (NozzleBlockEntity)blockEntity;
                    DelayRender.render(nbe);
                } else if (blockEntity instanceof ArmBlockEntity) {
                    ArmBlockEntity abe = (ArmBlockEntity)blockEntity;
                    DelayRender.render(abe);
                } else if (blockEntity instanceof EjectorBlockEntity) {
                    EjectorBlockEntity ebe = (EjectorBlockEntity)blockEntity;
                    DelayRender.render(ebe);
                }
            }
            return newValue <= 0;
        });
    }

    public static void render(@NotNull EncasedFanBlockEntity efbe) {
        AirCurrent airCurrent = efbe.airCurrent;
        int color = DelayRender.getColor(airCurrent.pushing);
        class_238 bounds = airCurrent.bounds;
        CreateClient.OUTLINER.chaseAABB((Object)("FanAirBox" + String.valueOf(efbe)), bounds).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(airCurrent.maxDistance);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            double offsetDistance = (double)airCurrent.maxDistance * offset;
            class_2350.class_2351 axis = airCurrent.direction.method_10166();
            double min = switch (axis) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> bounds.field_1323;
                case class_2350.class_2351.field_11052 -> bounds.field_1322;
                case class_2350.class_2351.field_11051 -> bounds.field_1321;
            };
            double max = switch (axis) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> bounds.field_1320;
                case class_2350.class_2351.field_11052 -> bounds.field_1325;
                case class_2350.class_2351.field_11051 -> bounds.field_1324;
            };
            double pos = airCurrent.pushing == airCurrent.direction.method_10171().method_10181() > 0 ? min + offsetDistance : max - offsetDistance;
            class_238 flowBound = switch (axis) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> new class_238(pos, bounds.field_1322, bounds.field_1321, pos, bounds.field_1325, bounds.field_1324);
                case class_2350.class_2351.field_11052 -> new class_238(bounds.field_1323, pos, bounds.field_1321, bounds.field_1320, pos, bounds.field_1324);
                case class_2350.class_2351.field_11051 -> new class_238(bounds.field_1323, bounds.field_1322, pos, bounds.field_1320, bounds.field_1325, pos);
            };
            String id = "FanAirFlowBox" + String.valueOf(efbe) + i;
            if (offset > 0.98) {
                CreateClient.OUTLINER.remove((Object)id);
                continue;
            }
            CreateClient.OUTLINER.chaseAABB((Object)id, flowBound).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static void render(@NotNull NozzleBlockEntity nbe) {
        class_243 center = VecHelper.getCenterOf((class_2382)nbe.method_11016());
        NozzleBlockEntityAccessor accessor = (NozzleBlockEntityAccessor)nbe;
        boolean pushing = accessor.getPushing();
        float range = accessor.getRange();
        int color = DelayRender.getColor(pushing);
        CreateClient.OUTLINER.chaseAABB((Object)("NozzleAirBox" + String.valueOf(nbe)), new class_238(center, center).method_1014((double)(range / 2.0f))).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(range);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            String id = "NozzleAirFlowBox" + String.valueOf(nbe) + i;
            if (offset > 0.98) {
                CreateClient.OUTLINER.remove((Object)id);
                continue;
            }
            double radius = pushing ? offset * (double)range / 2.0 : (1.0 - offset) * (double)range / 2.0;
            class_238 flowBound = new class_238(center, center).method_1014(radius);
            CreateClient.OUTLINER.chaseAABB((Object)id, flowBound).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static int getColor(boolean pushing) {
        return pushing ? CCG.CONFIG.delayRender.airBoxPushColor : CCG.CONFIG.delayRender.airBoxPullColor;
    }

    public static double getOffset(int i, int numberOfFlowBoxes) {
        return ((double)System.currentTimeMillis() + (double)i * (3000.0 / (double)numberOfFlowBoxes)) % 3000.0 / 3000.0;
    }

    public static int getNumberOfFlowBoxes(float range) {
        return (int)(Math.log(range) + 1.0);
    }

    public static void render(@NotNull ArmBlockEntity abe) {
        ArmBlockEntityAccessor accessor = (ArmBlockEntityAccessor)abe;
        DelayRender.drawArmIO(abe, accessor.getInputs());
        DelayRender.drawArmIO(abe, accessor.getOutputs());
    }

    public static void drawArmIO(@NotNull ArmBlockEntity abe, List<ArmInteractionPoint> list) {
        list.forEach(point -> {
            if (!point.isValid()) {
                return;
            }
            class_1937 level = point.getLevel();
            class_2338 pos = point.getPos();
            CreateClient.OUTLINER.chaseAABB((Object)("ArmIOBox" + String.valueOf(point)), level.method_8320(pos).method_26218((class_1922)level, pos).method_1107().method_996(pos)).withFaceTextures(AllSpecialTextures.HIGHLIGHT_CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(point.getMode().getColor());
            CreateClient.OUTLINER.showLine((Object)("ArmIOLine" + String.valueOf(point)), abe.method_11016().method_46558(), point.getPos().method_46558()).lineWidth(0.125f).colored(point.getMode().getColor());
        });
    }

    public static void render(@NotNull EjectorBlockEntity ebe) {
        CreateClient.OUTLINER.chaseAABB((Object)("EjectorTargetBox" + String.valueOf(ebe)), new class_238(ebe.getTargetPosition())).lineWidth(0.0625f).colored(CCG.CONFIG.delayRender.airBoxPushColor);
    }
}

