/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.armor.CardboardArmorItem;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGLang;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Common {
    public static StockTickerBlockEntity lastSTBE;
    public static int index;
    public static int scrollDeltaY;

    public static boolean testForStealth(LocalPlayer player) {
        boolean allMatch = Stream.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET).allMatch(slot -> player.getItemBySlot(slot).getItem() instanceof CardboardArmorItem);
        return CCG.CONFIG.chainConveyor.cardBoardedYourself && !player.getAbilities().flying && allMatch;
    }

    public static void renderItemStack(GuiGraphics guiGraphics, ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        TooltipFlag.Default tooltipFlag = mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        List tooltipLines = itemStack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)tooltipFlag);
        int n = tooltipLines.size();
        Objects.requireNonNull(font);
        int height = Math.max(10, n * 9 - 60);
        int x = guiGraphics.guiWidth() / 2 + (Integer)AllConfigs.client().overlayOffsetX.get();
        int y = guiGraphics.guiHeight() / 2 + (Integer)AllConfigs.client().overlayOffsetY.get();
        guiGraphics.renderItem(itemStack, x + 10, y - 16);
        guiGraphics.renderItemDecorations(font, itemStack, x + 10, y - 16);
        guiGraphics.renderTooltip(font, itemStack, x + 22, y - height);
    }

    @Nullable
    public static KineticBlockEntity getKBE() {
        BlockEntity blockEntity = Common.getBE();
        if (!(blockEntity instanceof KineticBlockEntity)) {
            return null;
        }
        KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
        return kbe;
    }

    @Nullable
    public static BlockEntity getBE() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return null;
        }
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        return mc.level.getBlockEntity(blockHitResult.getBlockPos());
    }

    @Nullable
    public static Block getB() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return null;
        }
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        return mc.level.getBlockState(blockHitResult.getBlockPos()).getBlock();
    }

    public static boolean addFanTooltip(List<Component> tooltip, boolean pushing, float range, int divide) {
        if (range == 0.0f) {
            return false;
        }
        CCGLang.translate("tooltip.windState", new Object[0]).forGoggles(tooltip);
        CCGLang.number(range / (float)divide).space().translate(pushing ? "tooltip.pushRange" : "tooltip.pullRange", new Object[0]).color(pushing ? CCG.CONFIG.delayRender.windPushColor : CCG.CONFIG.delayRender.windPullColor).forGoggles(tooltip);
        return true;
    }

    public static boolean addBurnerTooltip(List<Component> tooltip, int remainingBurnTime, boolean isCreative, BlazeBurnerBlockEntity.FuelType activeFuel) {
        CCGLang.translate("tooltip.burnerState", new Object[0]).forGoggles(tooltip);
        LangBuilder langBuilder = CCGLang.text(isCreative ? "\u221e" : String.format("%.2f", Float.valueOf((float)remainingBurnTime / 20.0f))).text(String.format(" / %d ", 500)).translate("tooltip.seconds", new Object[0]);
        langBuilder.style(switch (activeFuel) {
            case BlazeBurnerBlockEntity.FuelType.SPECIAL -> ChatFormatting.AQUA;
            case BlazeBurnerBlockEntity.FuelType.NORMAL -> ChatFormatting.YELLOW;
            default -> ChatFormatting.GRAY;
        }).forGoggles(tooltip);
        return true;
    }

    @Nullable
    public static ItemStack getRelevantFilterItem() {
        SmartBlockEntity sbe;
        BlockEntity blockEntity;
        block6: {
            block5: {
                Minecraft mc = Minecraft.getInstance();
                if (mc.screen != null) {
                    Screen screen = mc.screen;
                    if (!(screen instanceof AbstractContainerScreen)) {
                        return null;
                    }
                    AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                    Slot slot = screen2.getSlotUnderMouse();
                    return slot == null ? null : slot.getItem();
                }
                blockEntity = Common.getBE();
                if (!(blockEntity instanceof SmartBlockEntity)) break block5;
                sbe = (SmartBlockEntity)blockEntity;
                blockEntity = mc.hitResult;
                if (blockEntity instanceof BlockHitResult) break block6;
            }
            return null;
        }
        BlockHitResult blockHitResult = (BlockHitResult)blockEntity;
        FilteringBehaviour behaviour = (FilteringBehaviour)sbe.getBehaviour(FilteringBehaviour.TYPE);
        return behaviour == null ? null : behaviour.getFilter(blockHitResult.getDirection());
    }

    public static void displayMessage(LangBuilder builder) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.displayClientMessage((Component)builder.component(), true);
        }
    }

    public static void playSound(SoundEvent sound, float pitch, float volume) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void playSound(AllSoundEvents.SoundEntry entry) {
        Common.playSound(entry.getMainEvent(), 0.25f, 1.0f);
    }

    public static void playSound(SoundEvent sound) {
        Common.playSound(sound, 1.0f, 1.0f);
    }

    @Nullable
    public static AABB getBounds(BlockPos blockPos) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        VoxelShape shape = level.getBlockState(blockPos).getShape((BlockGetter)level, blockPos);
        return (shape.isEmpty() ? Shapes.block() : shape).bounds().move(blockPos);
    }

    static {
        index = 1;
    }
}

