/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.crate.CreativeCrateBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TooltipUtil {
    public static boolean addFanTooltip(List<Component> tooltip, boolean pushing, float range, int divide) {
        if (range == 0.0f) {
            return false;
        }
        CCGLang.translate("tooltip.windState", new Object[0]).forGoggles(tooltip);
        CCGLang.number(range / (float)divide).space().translate(pushing ? "tooltip.pushRange" : "tooltip.pullRange", new Object[0]).color(pushing ? CCG.CONFIG.delayRender.windPushColor : CCG.CONFIG.delayRender.windPullColor).forGoggles(tooltip);
        return true;
    }

    public static boolean addBurnerTooltip(List<Component> tooltip, int remainingBurnTime, boolean isCreative, BlazeBurnerBlockEntity.FuelType activeFuel) {
        CCGLang.translate("tooltip.burnerState", new Object[0]).forGoggles(tooltip);
        LangBuilder langBuilder = CCGLang.text(isCreative ? "\u221e" : String.format("%.2f", Float.valueOf((float)remainingBurnTime / 20.0f))).text(String.format(" / %d ", 500)).translate("tooltip.seconds", new Object[0]);
        langBuilder.style(switch (activeFuel) {
            case BlazeBurnerBlockEntity.FuelType.SPECIAL -> ChatFormatting.AQUA;
            case BlazeBurnerBlockEntity.FuelType.NORMAL -> ChatFormatting.YELLOW;
            default -> ChatFormatting.GRAY;
        }).forGoggles(tooltip);
        return true;
    }

    public static boolean addCannonTooltip(List<Component> tooltip, @NotNull SchematicannonBlockEntity sbe) {
        CCGLang.translate("tooltip.cannonState", new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)("schematicannon.status." + sbe.statusMsg), (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
        int shotsLeft = sbe.remainingFuel;
        int shotsLeftWithItems = shotsLeft + sbe.inventory.getStackInSlot(4).m_41613_() * sbe.getShotsPerGunpowder();
        if (sbe.hasCreativeCrate) {
            CreateLang.translate((String)"gui.schematicannon.gunpowderLevel", (Object[])new Object[]{"100"}).forGoggles(tooltip);
            CCGLang.text("(").add(((CreativeCrateBlock)AllBlocks.CREATIVE_CRATE.get()).m_49954_()).text(")").style(ChatFormatting.DARK_PURPLE).forGoggles(tooltip);
        } else {
            int fillPercent = (int)((float)shotsLeft / (float)sbe.getShotsPerGunpowder() * 100.0f);
            CreateLang.translate((String)"gui.schematicannon.gunpowderLevel", (Object[])new Object[]{fillPercent}).forGoggles(tooltip);
            CreateLang.translate((String)"gui.schematicannon.shotsRemaining", (Object[])new Object[]{Component.m_237113_((String)Integer.toString(shotsLeft)).m_130940_(ChatFormatting.BLUE)}).style(ChatFormatting.GRAY).forGoggles(tooltip);
            if (shotsLeftWithItems != shotsLeft) {
                CreateLang.translate((String)"gui.schematicannon.shotsRemainingWithBackup", (Object[])new Object[]{Component.m_237113_((String)Integer.toString(shotsLeftWithItems)).m_130940_(ChatFormatting.BLUE)}).style(ChatFormatting.GRAY).forGoggles(tooltip);
            }
        }
        if (sbe.state.equals((Object)SchematicannonBlockEntity.State.RUNNING)) {
            CCGLang.translate("tooltip.printProgress", new Object[0]).forGoggles(tooltip);
            float progress = sbe.schematicProgress * 100.0f;
            CCGLang.text(String.format("%.2f%%", Float.valueOf(progress))).color(new Color((int)(255.0 - (double)progress * 2.55), (int)((double)progress * 2.55), 128)).forGoggles(tooltip);
        }
        return true;
    }
}

