/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.event;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGUtil;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;

public class KineticDebugger {
    public static BlockPos lastSource;
    public static List<KineticBlockEntity> cachedKBEPath;

    public static void tick(TickEvent.ClientTickEvent ignoredEvent) {
        if (!CCG.CONFIG.misc.rainbowDebug) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_() || mc.f_91080_ != null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        KineticBlockEntity kbe = CCGUtil.getKBE();
        if (kbe == null) {
            return;
        }
        KineticDebugger.renderAxisLine(kbe);
        KineticDebugger.updateKBEPath(level, kbe);
        KineticDebugger.renderKineticPath(level, cachedKBEPath, level.m_46467_());
    }

    public static void updateKBEPath(ClientLevel level, @NotNull KineticBlockEntity kbe) {
        if (kbe.source == lastSource && cachedKBEPath != null) {
            return;
        }
        ArrayDeque<KineticBlockEntity> kbePath = new ArrayDeque<KineticBlockEntity>();
        KineticBlockEntity currentBE = kbe;
        while (currentBE != null) {
            KineticBlockEntity kbeSource;
            kbePath.addFirst(currentBE);
            if (currentBE.source == null) break;
            BlockEntity blockEntity = level.m_7702_(currentBE.source);
            currentBE = blockEntity instanceof KineticBlockEntity ? (kbeSource = (KineticBlockEntity)blockEntity) : null;
        }
        cachedKBEPath = new ArrayList<KineticBlockEntity>(kbePath);
        lastSource = kbe.source;
    }

    public static void renderKineticPath(ClientLevel level, @NotNull List<KineticBlockEntity> kbePath, long time) {
        for (int depth = 0; depth < kbePath.size(); ++depth) {
            KineticBlockEntity nodeBE = kbePath.get(depth);
            int rgb = KineticDebugger.getRainbowColor(depth, time);
            Frustum frustum = Minecraft.m_91087_().f_91060_.getFrustum();
            if (KineticDebugger.isAABBInFrustum(nodeBE, level, frustum)) {
                KineticDebugger.renderOutline(nodeBE, depth, rgb);
            }
            if (nodeBE.source == null || !KineticDebugger.isLineInFrustum((Vec3i)nodeBE.m_58899_(), (Vec3i)nodeBE.source, frustum)) continue;
            KineticDebugger.renderKineticLine(nodeBE, depth, rgb);
        }
    }

    public static boolean isAABBInFrustum(@NotNull KineticBlockEntity kbe, @NotNull ClientLevel level, Frustum frustum) {
        BlockPos pos = kbe.m_58899_();
        VoxelShape shape = level.m_8055_(pos).m_60816_((BlockGetter)level, pos);
        if (shape.m_83281_()) {
            return false;
        }
        return frustum.m_113029_(shape.m_83215_().m_82338_(pos));
    }

    public static boolean isLineInFrustum(Vec3i start, Vec3i end, @NotNull Frustum frustum) {
        return frustum.m_113029_(new AABB(VecHelper.getCenterOf((Vec3i)start), VecHelper.getCenterOf((Vec3i)end)));
    }

    public static void renderOutline(@NotNull KineticBlockEntity kbe, int depth, int rgb) {
        if (kbe.getTheoreticalSpeed() == 0.0f) {
            return;
        }
        BlockPos blockPos = kbe.m_58899_();
        AABB bounds = CCGUtil.getBounds(blockPos);
        if (bounds == null) {
            return;
        }
        Outliner.getInstance().chaseAABB((Object)("KineticOutline" + depth), bounds).lineWidth(0.0625f).colored(rgb);
    }

    public static int getRainbowColor(int depth, long time) {
        return Color.HSBtoRGB(1.0f - ((float)depth * 0.05f - (float)(time % 200L) / 100.0f) % 1.0f, 0.8f, 1.0f);
    }

    public static void renderKineticLine(@NotNull KineticBlockEntity kbe, int depth, int rgb) {
        BlockPos end;
        if (kbe.source == null) {
            return;
        }
        BlockPos start = kbe.m_58899_();
        if (start.m_123333_((Vec3i)(end = kbe.source)) == 1) {
            return;
        }
        Outliner.getInstance().showLine((Object)("KineticLine" + depth), VecHelper.getCenterOf((Vec3i)start), VecHelper.getCenterOf((Vec3i)end)).lineWidth(0.125f).colored(rgb);
    }

    public static void renderAxisLine(@NotNull KineticBlockEntity kbe) {
        BlockState state = kbe.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof IRotate)) {
            return;
        }
        IRotate iRotate = (IRotate)block;
        Vec3 vec = Vec3.m_82528_((Vec3i)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)iRotate.getRotationAxis(state)).m_122436_());
        Vec3 center = VecHelper.getCenterOf((Vec3i)kbe.m_58899_());
        Outliner.getInstance().showLine((Object)"RotationAxis", center.m_82549_(vec), center.m_82546_(vec)).lineWidth(0.125f);
    }
}

