/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.goggles;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGConfig;
import io.github.forgestove.create_cyber_goggles.event.CCGKey;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={KineticBlockEntity.class}, remap=false)
public abstract class KineticBlockEntityMixin {
    @Shadow
    protected float capacity;
    @Shadow
    protected float stress;
    @Shadow
    protected float speed;
    @Shadow
    protected boolean overStressed;

    @Inject(method={"addToGoggleTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    public void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> returnable) {
        float stressAtBase;
        CCGConfig.Goggles goggles = CCG.CONFIG.goggles;
        if (!goggles.enhancedInfo) {
            return;
        }
        boolean hide = !goggles.hideStaticKineticInfo || !Mth.m_14033_((float)this.speed, (float)0.0f);
        returnable.setReturnValue((Object)hide);
        if (!hide) {
            return;
        }
        if (IRotate.StressImpact.isEnabled() && !Mth.m_14033_((float)(stressAtBase = this.calculateStressApplied()), (float)0.0f)) {
            this.addStressImpactStats(tooltip, stressAtBase);
        }
        CreateLang.translate((String)"gui.goggles.kinetic_stats", (Object[])new Object[0]).forGoggles(tooltip);
        IRotate.SpeedLevel.getFormattedSpeedText((float)this.speed, (boolean)this.overStressed).forGoggles(tooltip);
        if (!CCGKey.showStress.isKeyDown()) {
            return;
        }
        double stressFraction = this.stress / (this.capacity == 0.0f ? 1.0f : this.capacity);
        CreateLang.translate((String)"gui.stressometer.title", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (this.speed == 0.0f) {
            CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)0)).translate("gui.stressometer.no_rotation", new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
        } else {
            IRotate.StressImpact.getFormattedStressText((double)stressFraction).forGoggles(tooltip);
            CreateLang.translate((String)"gui.stressometer.capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            double remainingCapacity = this.capacity - this.stress;
            LangBuilder su = CreateLang.translate((String)"generic.unit.stress", (Object[])new Object[0]);
            LangBuilder stressTip = CreateLang.number((double)remainingCapacity).add(su).style(IRotate.StressImpact.of((double)stressFraction).getRelativeColor());
            if (remainingCapacity != (double)this.capacity) {
                stressTip.text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)this.capacity).add(su).style(ChatFormatting.DARK_GRAY));
            }
            stressTip.forGoggles(tooltip, 1);
        }
    }

    @Shadow
    public abstract float calculateStressApplied();

    @Shadow
    protected abstract void addStressImpactStats(List<Component> var1, float var2);
}

