/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.catnip.render.BindableTexture;
import com.zurrtum.create.content.kinetics.fan.AirCurrent;
import com.zurrtum.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.zurrtum.create.content.kinetics.fan.NozzleBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.NozzleBlockEntityAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class DelayRender {
    public static Object2IntOpenHashMap<class_2586> cachedBE = new Object2IntOpenHashMap();

    public static void tick(class_310 mc) {
        if (!CCG.CONFIG.outliner.renderAnalogBox) {
            return;
        }
        if (mc.field_1687 == null) {
            cachedBE.clear();
            return;
        }
        if (mc.method_1493() || mc.field_1755 != null) {
            return;
        }
        class_2586 be = CCGUtil.getBlockEntity();
        if (be instanceof EncasedFanBlockEntity || be instanceof NozzleBlockEntity || be instanceof ArmBlockEntity || be instanceof EjectorBlockEntity || be instanceof PackagePortBlockEntity) {
            cachedBE.put((Object)be, CCG.CONFIG.outliner.delayRenderDuration);
        }
        if (cachedBE.isEmpty()) {
            return;
        }
        cachedBE.object2IntEntrySet().removeIf(entry -> {
            class_2586 blockEntity = (class_2586)entry.getKey();
            int newValue = entry.getIntValue() - 1;
            entry.setValue(newValue);
            if (!blockEntity.method_11015()) {
                class_2586 class_25862 = blockEntity;
                Objects.requireNonNull(class_25862);
                class_2586 selector0$temp = class_25862;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EncasedFanBlockEntity.class, NozzleBlockEntity.class, ArmBlockEntity.class, EjectorBlockEntity.class, PackagePortBlockEntity.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        EncasedFanBlockEntity efbe = (EncasedFanBlockEntity)selector0$temp;
                        DelayRender.render(efbe);
                        break;
                    }
                    case 1: {
                        NozzleBlockEntity nbe = (NozzleBlockEntity)selector0$temp;
                        DelayRender.render(nbe);
                        break;
                    }
                    case 2: {
                        ArmBlockEntity abe = (ArmBlockEntity)selector0$temp;
                        DelayRender.render(abe);
                        break;
                    }
                    case 3: {
                        EjectorBlockEntity ebe = (EjectorBlockEntity)selector0$temp;
                        DelayRender.render(ebe);
                        break;
                    }
                    case 4: {
                        PackagePortBlockEntity ppbe = (PackagePortBlockEntity)selector0$temp;
                        DelayRender.render(ppbe);
                        break;
                    }
                }
            }
            return newValue <= 0;
        });
    }

    public static void render(@NotNull EncasedFanBlockEntity efbe) {
        AirCurrent airCurrent = efbe.airCurrent;
        int color = DelayRender.getColor(airCurrent.pushing);
        class_238 bounds = airCurrent.bounds;
        Outliner.getInstance().chaseAABB((Object)("FanAirBox" + String.valueOf(efbe)), bounds).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(airCurrent.maxDistance);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            double offsetDistance = (double)airCurrent.maxDistance * offset;
            class_2350.class_2351 axis = airCurrent.direction.method_10166();
            double min = switch (axis) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> bounds.field_1323;
                case class_2350.class_2351.field_11052 -> bounds.field_1322;
                case class_2350.class_2351.field_11051 -> bounds.field_1321;
            };
            double max = switch (axis) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> bounds.field_1320;
                case class_2350.class_2351.field_11052 -> bounds.field_1325;
                case class_2350.class_2351.field_11051 -> bounds.field_1324;
            };
            double pos = airCurrent.pushing == airCurrent.direction.method_10171().method_10181() > 0 ? min + offsetDistance : max - offsetDistance;
            class_238 flowBound = switch (axis) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> new class_238(pos, bounds.field_1322, bounds.field_1321, pos, bounds.field_1325, bounds.field_1324);
                case class_2350.class_2351.field_11052 -> new class_238(bounds.field_1323, pos, bounds.field_1321, bounds.field_1320, pos, bounds.field_1324);
                case class_2350.class_2351.field_11051 -> new class_238(bounds.field_1323, bounds.field_1322, pos, bounds.field_1320, bounds.field_1325, pos);
            };
            String id = "FanAirFlowBox" + String.valueOf(efbe) + i;
            if (offset > 0.98) {
                Outliner.getInstance().remove((Object)id);
                continue;
            }
            Outliner.getInstance().chaseAABB((Object)id, flowBound).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static void render(@NotNull NozzleBlockEntity nbe) {
        NozzleBlockEntityAccessor accessor = (NozzleBlockEntityAccessor)nbe;
        boolean pushing = accessor.getPushing();
        float range = accessor.getRange();
        class_243 center = nbe.method_11016().method_46558();
        int color = DelayRender.getColor(pushing);
        Outliner.getInstance().chaseAABB((Object)("NozzleAirBox" + String.valueOf(nbe)), new class_238(center, center).method_1014((double)(range / 2.0f))).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(range);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            String id = "NozzleAirFlowBox" + String.valueOf(nbe) + i;
            if (offset > 0.98) {
                Outliner.getInstance().remove((Object)id);
                continue;
            }
            double radius = pushing ? offset * (double)range / 2.0 : (1.0 - offset) * (double)range / 2.0;
            class_238 flowBound = new class_238(center, center).method_1014(radius);
            Outliner.getInstance().chaseAABB((Object)id, flowBound).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static int getColor(boolean pushing) {
        return pushing ? CCG.CONFIG.outliner.outColor : CCG.CONFIG.outliner.inColor;
    }

    public static double getOffset(int i, int numberOfFlowBoxes) {
        return ((double)System.currentTimeMillis() + (double)i * (3000.0 / (double)numberOfFlowBoxes)) % 3000.0 / 3000.0;
    }

    public static int getNumberOfFlowBoxes(float range) {
        return (int)(Math.log(range) + 1.0);
    }

    public static void render(@NotNull ArmBlockEntity abe) {
        ArrayList<ArmInteractionPoint> allPoints = new ArrayList<ArmInteractionPoint>();
        allPoints.addAll(abe.inputs);
        allPoints.addAll(abe.outputs);
        allPoints.forEach(point -> {
            if (!point.isValid()) {
                return;
            }
            class_1937 level = point.getLevel();
            class_2338 pos = point.getPos();
            Outliner.getInstance().chaseAABB((Object)("ArmIOBox" + String.valueOf(point)), level.method_8320(pos).method_26218((class_1922)level, pos).method_1107().method_996(pos)).withFaceTextures((BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(point.getMode().getColor());
            Outliner.getInstance().showLine((Object)("ArmIOLine" + String.valueOf(point)), abe.method_11016().method_46558(), point.getPos().method_46558()).lineWidth(0.125f).colored(point.getMode().getColor());
        });
    }

    public static void render(@NotNull EjectorBlockEntity ebe) {
        Outliner.getInstance().chaseAABB((Object)("EjectorTargetBox" + String.valueOf(ebe)), CCGUtil.getBounds(ebe.getTargetPosition())).lineWidth(0.0625f).colored(CCG.CONFIG.outliner.outColor);
    }

    public static void render(@NotNull PackagePortBlockEntity ppbe) {
        class_310 mc = class_310.method_1551();
        class_2338 pos = ppbe.method_11016();
        if (ppbe.target == null) {
            return;
        }
        class_243 source = class_243.method_24955((class_2382)pos);
        class_243 target = ppbe.target.getExactTargetLocation(ppbe, (class_1936)mc.field_1687, pos);
        if (target == class_243.field_1353) {
            return;
        }
        int color = 10411635;
        Outliner.getInstance().showLine((Object)("PackagePortConnection" + String.valueOf(ppbe)), source, target).lineWidth(0.125f).colored(color);
        Outliner.getInstance().chaseAABB((Object)("ChainPointSelected" + String.valueOf(ppbe)), new class_238(target, target)).colored(color).lineWidth(0.2f).disableLineNormals();
    }
}

