/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class KineticDebugger {
    public static class_2338 lastSource;
    public static List<KineticBlockEntity> cachedKBEPath;

    public static void tick(class_310 mc) {
        if (!CCG.CONFIG.outliner.rainbowDebug) {
            return;
        }
        if (mc.method_1493() || CCGUtil.isInGUI() || mc.field_1687 == null) {
            return;
        }
        KineticBlockEntity kbe = CCGUtil.getBlockEntity(KineticBlockEntity.class);
        if (kbe == null) {
            return;
        }
        KineticDebugger.renderAxisLine(kbe);
        KineticDebugger.updateKBEPath(mc.field_1687, kbe);
        KineticDebugger.renderKineticPath(cachedKBEPath, mc.field_1687.method_8510());
    }

    public static void updateKBEPath(class_638 level, @NotNull KineticBlockEntity kbe) {
        if (kbe.source == lastSource && cachedKBEPath != null) {
            return;
        }
        ArrayDeque<KineticBlockEntity> kbePath = new ArrayDeque<KineticBlockEntity>();
        KineticBlockEntity currentBE = kbe;
        while (currentBE != null) {
            KineticBlockEntity kbeSource;
            kbePath.addFirst(currentBE);
            if (currentBE.source == null) break;
            class_2586 class_25862 = level.method_8321(currentBE.source);
            currentBE = class_25862 instanceof KineticBlockEntity ? (kbeSource = (KineticBlockEntity)class_25862) : null;
        }
        cachedKBEPath = List.copyOf(kbePath);
        lastSource = kbe.source;
    }

    public static void renderKineticPath(@NotNull List<KineticBlockEntity> kbePath, long time) {
        class_4604 frustum = CCGUtil.mc.field_1769.method_62222();
        for (int depth = 0; depth < kbePath.size(); ++depth) {
            KineticBlockEntity nodeBE = kbePath.get(depth);
            int rgb = KineticDebugger.getRainbowColor(depth, time);
            if (KineticDebugger.isAABBInFrustum(nodeBE, frustum)) {
                KineticDebugger.renderOutline(nodeBE, depth, rgb);
            }
            if (nodeBE.source == null || !KineticDebugger.isLineInFrustum((class_2382)nodeBE.method_11016(), (class_2382)nodeBE.source, frustum)) continue;
            KineticDebugger.renderKineticLine(nodeBE, depth, rgb);
        }
    }

    public static boolean isAABBInFrustum(@NotNull KineticBlockEntity kbe, class_4604 frustum) {
        if (CCGUtil.mc.field_1687 == null) {
            return false;
        }
        class_2338 pos = kbe.method_11016();
        class_265 shape = CCGUtil.mc.field_1687.method_8320(pos).method_26222((class_1922)CCGUtil.mc.field_1687, pos);
        if (shape.method_1110()) {
            return false;
        }
        return frustum.method_23093(shape.method_1107().method_996(pos));
    }

    @Contract(value="_, _, null -> false")
    public static boolean isLineInFrustum(class_2382 start, class_2382 end, class_4604 frustum) {
        return frustum != null && frustum.method_23093(new class_238(VecHelper.getCenterOf((class_2382)start), VecHelper.getCenterOf((class_2382)end)));
    }

    public static void renderOutline(@NotNull KineticBlockEntity kbe, int depth, int rgb) {
        if (kbe.getTheoreticalSpeed() == 0.0f) {
            return;
        }
        class_2338 blockPos = kbe.method_11016();
        CCGUtil.outliner.chaseAABB((Object)("KineticOutline" + depth), CCGUtil.getBounds(blockPos)).lineWidth(0.0625f).colored(rgb);
    }

    public static int getRainbowColor(int depth, long time) {
        return Color.HSBtoRGB(1.0f - ((float)depth * 0.05f - (float)(time % 50L) / 50.0f) % 1.0f, 0.8f, 1.0f);
    }

    public static void renderKineticLine(@NotNull KineticBlockEntity kbe, int depth, int rgb) {
        class_2338 end;
        if (kbe.source == null) {
            return;
        }
        class_2338 start = kbe.method_11016();
        if (start.method_19455((class_2382)(end = kbe.source)) == 1) {
            return;
        }
        CCGUtil.outliner.showLine((Object)("KineticLine" + depth), VecHelper.getCenterOf((class_2382)start), VecHelper.getCenterOf((class_2382)end)).lineWidth(0.125f).colored(rgb);
    }

    public static void renderAxisLine(@NotNull KineticBlockEntity kbe) {
        class_2680 state = kbe.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof IRotate)) {
            return;
        }
        IRotate iRotate = (IRotate)class_22482;
        class_243 vec = class_243.method_24954((class_2382)class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)iRotate.getRotationAxis(state)).method_62675());
        class_243 center = VecHelper.getCenterOf((class_2382)kbe.method_11016());
        CCGUtil.outliner.showLine((Object)"RotationAxis", center.method_1019(vec), center.method_1020(vec)).lineWidth(0.125f);
    }
}

