/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.SpeedGaugeTooltipBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.StressGaugeTooltipBehaviour;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.armor.BacktankBlockEntity;
import com.zurrtum.create.content.equipment.armor.BacktankUtil;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.event.CCGKey;
import io.github.forgestove.create_cyber_goggles.core.event.Outliner;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class GoggleTooltipUtil {
    public static void kinetic(List<class_2561> tooltip, @NotNull KineticBlockEntity kbe, float stress, float capacity) {
        float stressAtBase;
        float speed = kbe.getTheoreticalSpeed();
        if (IRotate.StressImpact.isEnabled() && !class_3532.method_15347((float)(stressAtBase = kbe.calculateStressApplied()), (float)0.0f)) {
            CreateLang.translate((String)"tooltip.stressImpact", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            CreateLang.number((double)(stressAtBase * Math.abs(speed))).translate("generic.unit.stress", new Object[0]).style(class_124.field_1075).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(class_124.field_1063)).forGoggles(tooltip, 1);
        }
        CreateLang.translate((String)"gui.speedometer.title", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        SpeedGaugeTooltipBehaviour.getFormattedSpeedText((float)speed, (boolean)kbe.isOverStressed()).forGoggles(tooltip);
        if (!CCGKey.showStress.keyMapping.method_1434()) {
            return;
        }
        double stressFraction = stress / (capacity == 0.0f ? 1.0f : capacity);
        CreateLang.translate((String)"gui.stressometer.title", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        if (speed == 0.0f) {
            CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)0)).translate("gui.stressometer.no_rotation", new Object[0]).style(class_124.field_1063).forGoggles(tooltip);
            return;
        }
        StressGaugeTooltipBehaviour.getFormattedStressText((double)stressFraction).forGoggles(tooltip);
        CreateLang.translate((String)"gui.stressometer.capacity", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        double remainingCapacity = capacity - stress;
        LangBuilder su = CreateLang.translate((String)"generic.unit.stress", (Object[])new Object[0]);
        LangBuilder stressTip = CreateLang.number((double)remainingCapacity).add(su).style(IRotate.StressImpact.of((double)stressFraction).getRelativeColor());
        if (remainingCapacity != (double)capacity) {
            stressTip.text(class_124.field_1080, " / ").add(CreateLang.number((double)capacity).add(su).style(class_124.field_1063));
        }
        stressTip.forGoggles(tooltip, 1);
    }

    public static void generatingKinetic(List<class_2561> tooltip, @NotNull GeneratingKineticBlockEntity gkbe) {
        float stressBase = gkbe.calculateAddedStressCapacity();
        if (!class_3532.method_15347((float)stressBase, (float)0.0f)) {
            CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            float speed = gkbe.getTheoreticalSpeed();
            float generatedSpeed = gkbe.getGeneratedSpeed();
            if (speed != generatedSpeed) {
                stressBase *= generatedSpeed / speed;
            }
            CreateLang.number((double)Math.abs(stressBase * speed)).translate("generic.unit.stress", new Object[0]).style(class_124.field_1075).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(class_124.field_1063)).forGoggles(tooltip, 1);
        }
    }

    public static boolean fan(List<class_2561> tooltip, boolean pushing, float range) {
        if (!CCG.CONFIG.goggles.enhancedInfo || range == 0.0f) {
            return false;
        }
        CCGLang.translate("tooltip.windState", new Object[0]).forGoggles(tooltip);
        CCGLang.number(range).space().translate(pushing ? "tooltip.pushRange" : "tooltip.pullRange", new Object[0]).color(Outliner.getColor(pushing)).forGoggles(tooltip);
        return true;
    }

    public static boolean burner(List<class_2561> tooltip, int remainingBurnTime, boolean isCreative, BlazeBurnerBlockEntity.FuelType activeFuel) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return false;
        }
        if (remainingBurnTime == 0 && !isCreative) {
            return false;
        }
        class_124 format = switch (activeFuel) {
            case BlazeBurnerBlockEntity.FuelType.SPECIAL -> class_124.field_1075;
            case BlazeBurnerBlockEntity.FuelType.NORMAL -> class_124.field_1065;
            default -> class_124.field_1064;
        };
        CCGLang.translate("tooltip.burnerState", new Object[0]).forGoggles(tooltip);
        CCGLang.translate(class_124.field_1080, "tooltip.leftTime", new Object[0]).add(CCGLang.text(format, isCreative ? "\u221e" : String.valueOf(remainingBurnTime / 20))).add(CCGLang.text(" / %d ".formatted(500))).add(CCGLang.seconds()).forGoggles(tooltip);
        return true;
    }

    public static boolean cannon(List<class_2561> tooltip, @NotNull SchematicannonBlockEntity sbe) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return false;
        }
        CCGLang.translate("tooltip.cannonState", new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)("schematicannon.status." + sbe.statusMsg), (Object[])new Object[0]).style(class_124.field_1065).forGoggles(tooltip);
        int shotsLeft = sbe.remainingFuel;
        int shotsLeftWithItems = shotsLeft + sbe.inventory.method_5438(4).method_7947() * sbe.getShotsPerGunpowder();
        if (sbe.hasCreativeCrate) {
            CreateLang.translate((String)"gui.schematicannon.gunpowderLevel", (Object[])new Object[]{"100"}).forGoggles(tooltip);
            CCGLang.text("(").add(AllBlocks.CREATIVE_CRATE.method_9518()).text(")").style(class_124.field_1064).forGoggles(tooltip);
        } else {
            int fillPercent = (int)((float)shotsLeft / (float)sbe.getShotsPerGunpowder() * 100.0f);
            CreateLang.translate((String)"gui.schematicannon.gunpowderLevel", (Object[])new Object[]{fillPercent}).forGoggles(tooltip);
            CreateLang.translate((String)"gui.schematicannon.shotsRemaining", (Object[])new Object[]{CCGLang.number(class_124.field_1078, shotsLeft)}).style(class_124.field_1080).forGoggles(tooltip);
            if (shotsLeftWithItems != shotsLeft) {
                CreateLang.translate((String)"gui.schematicannon.shotsRemainingWithBackup", (Object[])new Object[]{CCGLang.number(class_124.field_1078, shotsLeftWithItems)}).style(class_124.field_1080).forGoggles(tooltip);
            }
        }
        if (!sbe.state.equals((Object)SchematicannonBlockEntity.State.RUNNING)) {
            return true;
        }
        CCGLang.translate("tooltip.printProgress", new Object[0]).forGoggles(tooltip);
        CCGLang.fraction(sbe.blocksPlaced, sbe.blocksToPlace).forGoggles(tooltip);
        CCGLang.progress(sbe.schematicProgress, 20).forGoggles(tooltip);
        return true;
    }

    public static boolean backtank(List<class_2561> tooltip, BacktankBlockEntity bbe, int capacityEnchantLevel, int leftTick) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return false;
        }
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).style(class_124.field_1080).add(CCGLang.fraction(bbe.airLevel, BacktankUtil.maxAir((int)capacityEnchantLevel))).forGoggles(tooltip);
        if (bbe.getSpeed() == 0.0f || leftTick == 0) {
            return false;
        }
        CCGLang.translate("tooltip.leftTime", new Object[0]).style(class_124.field_1080).add(CCGLang.number(class_124.field_1065, leftTick / 20)).space().add(CCGLang.seconds().style(class_124.field_1080)).forGoggles(tooltip);
        return true;
    }

    public static void beltThroughput(List<class_2561> tooltip, double itemsPerSecond) {
        if (itemsPerSecond < 0.1) {
            return;
        }
        CCGLang.translate("tooltip.beltThroughput", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        CCGLang.text(String.format("%.2f", itemsPerSecond)).style(class_124.field_1065).add(CCGLang.text(" / ").style(class_124.field_1063).add(CCGLang.seconds().style(class_124.field_1063))).forGoggles(tooltip, 1);
    }
}

