/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeStove.create_cyber_goggles.mixin.goggles;

import com.ForgeStove.create_cyber_goggles.Config;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticEffectHandler;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KineticEffectHandler.class})
public abstract class KineticEffectHandlerMixin {
    @Shadow
    KineticBlockEntity kte;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo callbackInfo) {
        HitResult hitResult;
        if (!((Boolean)Config.enableKineticEffect.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused() || !((hitResult = mc.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return;
        }
        if (!blockHitResult.getBlockPos().equals((Object)this.kte.getBlockPos())) {
            return;
        }
        float speed = this.kte.getSpeed();
        if (speed == 0.0f) {
            return;
        }
        BlockState state = this.kte.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof KineticBlock)) {
            return;
        }
        KineticBlock kineticBlock = (KineticBlock)block;
        Level level = this.kte.getLevel();
        if (level == null) {
            return;
        }
        Direction.Axis rotationAxis = kineticBlock.getRotationAxis(state);
        if (rotationAxis == null) {
            return;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.kte.getBlockPos());
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of((float)speed);
        level.addParticle((ParticleOptions)new RotationIndicatorParticleData(speedLevel.getColor(), (float)speedLevel.getParticleSpeed() * Math.signum(speed), kineticBlock.getParticleInitialRadius(), kineticBlock.getParticleTargetRadius(), 10, rotationAxis), center.x, center.y, center.z, 0.0, 0.0, 0.0);
    }
}

