/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.provider;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.BeltInventory;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.IItemRenderable;
import io.github.forgestove.create_cyber_goggles.core.util.TooltipUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BeltBlockEntity.class}, remap=false)
public abstract class BeltBlockEntityMixin
extends KineticBlockEntity
implements IHaveGoggleInformation,
IItemRenderable {
    @Unique
    private static final float ccg$SMOOTHING = 0.1f;
    @Unique
    private final int[] ccg$itemHistory = new int[200];
    @Shadow
    public int index;
    @Unique
    private int ccg$lastItemCount;
    @Unique
    private int ccg$historyIndex = 0;
    @Unique
    private int ccg$totalItemsInWindow = 0;
    @Unique
    private float ccg$smoothedRate = 0.0f;

    public BeltBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Shadow
    public abstract BeltBlockEntity getControllerBE();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        if (this.index != 0) {
            return;
        }
        BeltBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        BeltInventory inventory = controllerBE.getInventory();
        if (inventory == null) {
            return;
        }
        List items = inventory.getTransportedItems();
        int currentItemCount = 0;
        if (items != null) {
            for (TransportedItemStack transportedStack : items) {
                if (transportedStack == null || transportedStack.stack == null || transportedStack.stack.m_41619_()) continue;
                currentItemCount += transportedStack.stack.m_41613_();
            }
        }
        int itemsPassedThisTick = 0;
        if (currentItemCount < this.ccg$lastItemCount) {
            itemsPassedThisTick = this.ccg$lastItemCount - currentItemCount;
        }
        this.ccg$lastItemCount = currentItemCount;
        this.ccg$totalItemsInWindow -= this.ccg$itemHistory[this.ccg$historyIndex];
        this.ccg$itemHistory[this.ccg$historyIndex] = itemsPassedThisTick;
        this.ccg$totalItemsInWindow += itemsPassedThisTick;
        this.ccg$historyIndex = (this.ccg$historyIndex + 1) % 200;
        float rawRate = (float)this.ccg$totalItemsInWindow / 10.0f;
        this.ccg$smoothedRate = this.ccg$smoothedRate == 0.0f ? rawRate : this.ccg$smoothedRate * 0.9f + rawRate * 0.1f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean add = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!CCG.CONFIG.goggles.enhancedInfo || this.getSpeed() == 0.0f) {
            return add;
        }
        BeltBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE != null) {
            BeltBlockEntityMixin controllerMixin = (BeltBlockEntityMixin)controllerBE;
            TooltipUtil.beltThroughput(tooltip, (int)controllerMixin.ccg$smoothedRate);
        }
        return add;
    }

    @Override
    public ItemStack ccg$getItemStack() {
        BeltBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return null;
        }
        BeltInventory inventory = controllerBE.getInventory();
        if (inventory == null) {
            return null;
        }
        TransportedItemStack stackAtOffset = inventory.getStackAtOffset(this.index);
        return stackAtOffset == null ? null : stackAtOffset.stack;
    }
}

