/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.zurrtum.create.infrastructure.particle.RotationIndicatorParticleData;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.RotationPropagatorAccessor;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;

public class KineticParticle {
    public static void tick(class_310 mc) {
        if (!CCG.CONFIG.goggles.enableKineticEffect) {
            return;
        }
        if (mc.field_1687 == null || CCGUtil.isInGUI()) {
            return;
        }
        KineticBlockEntity kbe = CCGUtil.getBlockEntity(KineticBlockEntity.class);
        if (kbe == null) {
            return;
        }
        float kbeSpeed = kbe.getSpeed();
        if (kbeSpeed == 0.0f) {
            return;
        }
        class_2680 state = kbe.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof KineticBlock)) {
            return;
        }
        KineticBlock kb = (KineticBlock)class_22482;
        class_243 center = VecHelper.getCenterOf((class_2382)kbe.method_11016());
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of((float)kbeSpeed);
        float particleSpeed = (float)Math.max(10, speedLevel.getParticleSpeed()) * Math.signum(kbeSpeed);
        if (KineticParticle.renderShaftParticles(kbe, kb, state, center, speedLevel.getColor(), particleSpeed)) {
            return;
        }
        if (kb instanceof BeltBlock) {
            return;
        }
        KineticParticle.renderDefaultParticles(kb, state, center, speedLevel.getColor(), particleSpeed);
    }

    private static boolean renderShaftParticles(KineticBlockEntity kbe, KineticBlock kb, class_2680 state, class_243 center, int color, float particleSpeed) {
        boolean hasRendered = false;
        for (class_2350 direction : class_2350.values()) {
            if (!kb.hasShaftTowards((class_4538)CCGUtil.mc.field_1687, kbe.method_11016(), state, direction)) continue;
            class_2350.class_2351 axis = direction.method_10166();
            float directionSpeed = particleSpeed * RotationPropagatorAccessor.getAxisModifier(kbe, direction);
            double offset = (double)direction.method_10171().method_10181() / 2.0;
            class_243 axisVec = new class_243(axis == class_2350.class_2351.field_11048 ? offset : 0.0, axis == class_2350.class_2351.field_11052 ? offset : 0.0, axis == class_2350.class_2351.field_11051 ? offset : 0.0);
            class_243 pos = center.method_1019(axisVec);
            float initial = class_3532.method_15363((float)(kb.getParticleInitialRadius() / 2.0f), (float)0.2f, (float)0.3f);
            float target = class_3532.method_15363((float)(kb.getParticleTargetRadius() / 2.0f), (float)0.4f, (float)0.5f);
            RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, directionSpeed, initial, target, 10, axis);
            KineticParticle.spawnParticles(particleData, pos);
            hasRendered = true;
        }
        if (kb instanceof EncasedCogwheelBlock) {
            return false;
        }
        return hasRendered;
    }

    private static void renderDefaultParticles(@NotNull KineticBlock kb, class_2680 state, class_243 center, int color, float particleSpeed) {
        float initial = kb.getParticleInitialRadius();
        float target = kb.getParticleTargetRadius();
        RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, initial, target, 10, kb.getRotationAxis(state));
        KineticParticle.spawnParticles(particleData, center);
    }

    private static void spawnParticles(RotationIndicatorParticleData particleData, class_243 pos) {
        if (CCGUtil.mc.field_1687 == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            CCGUtil.mc.field_1687.method_8406((class_2394)particleData, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
        }
    }
}

