/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllMenuTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterMenu;
import com.simibubi.create.content.logistics.filter.FilterScreen;
import com.simibubi.create.content.logistics.filter.PackageFilterMenu;
import com.simibubi.create.content.logistics.filter.PackageFilterScreen;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGConfig;
import io.github.forgestove.create_cyber_goggles.CCGLang;
import io.github.forgestove.create_cyber_goggles.core.event.CCGKey;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.event.InputEvent;

public class KeyInput {
    public static StockTickerBlockEntity lastSTBE;

    public static void tick(InputEvent.Key ignoredEvent) {
        KeyInput.toggleGoggle();
        KeyInput.toggleDiving();
        KeyInput.openConfigScreen();
        KeyInput.openStockScreen();
        KeyInput.previewFilterScreen();
    }

    public static void toggleGoggle() {
        if (!CCGKey.toggleGoggle.isKeyDown()) {
            return;
        }
        CCGConfig.GameMode mode = CCG.CONFIG.gameMode;
        mode.enableGoggle = !mode.enableGoggle;
        LangBuilder builder = CCGLang.translate("message.goggle", new Object[0]).space().translate(mode.enableGoggle ? "message.enabled" : "message.disabled", new Object[0]);
        CCGUtil.displayMessage(builder);
        CCGUtil.playSound(mode.enableGoggle ? AllSoundEvents.CONFIRM_2 : AllSoundEvents.DENY);
    }

    public static void toggleDiving() {
        if (!CCGKey.toggleDiving.isKeyDown()) {
            return;
        }
        CCGConfig.Misc misc = CCG.CONFIG.misc;
        misc.allowDivingBoot = !misc.allowDivingBoot;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.screen != null) {
            return;
        }
        LangBuilder builder = CCGLang.translate("message.divingBoot", new Object[0]).space().translate(misc.allowDivingBoot ? "message.enabled" : "message.disabled", new Object[0]);
        CCGUtil.displayMessage(builder);
        CCGUtil.playSound(misc.allowDivingBoot ? AllSoundEvents.CONFIRM_2 : AllSoundEvents.DENY);
    }

    public static void openConfigScreen() {
        if (!CCGKey.openConfig.isKeyDown()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return;
        }
        mc.setScreen((Screen)AutoConfig.getConfigScreen(CCGConfig.class, null).get());
    }

    public static void openStockScreen() {
        if (!CCGKey.openStock.isKeyDown()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        BlockEntity blockEntity = CCGUtil.getBE();
        if (blockEntity instanceof StockTickerBlockEntity) {
            StockTickerBlockEntity stbe;
            lastSTBE = stbe = (StockTickerBlockEntity)blockEntity;
        }
        if (lastSTBE == null || lastSTBE.isRemoved()) {
            CCGUtil.displayMessage(CCGLang.translate("message.notStock", new Object[0]).text("  ").translate("key.openStock", new Object[0]).style(ChatFormatting.RED));
            CCGUtil.playSound(AllSoundEvents.DENY);
            return;
        }
        Inventory inv = player.getInventory();
        StockKeeperRequestMenu menu = new StockKeeperRequestMenu((MenuType)AllMenuTypes.STOCK_KEEPER_REQUEST.get(), -1, inv, lastSTBE);
        mc.setScreen((Screen)new StockKeeperRequestScreen(menu, inv, (Component)lastSTBE.getBlockState().getBlock().getName()));
    }

    public static void previewFilterScreen() {
        if (!CCGKey.previewFilter.isKeyDown()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack itemStack = CCGUtil.getRelevantFilterItem();
        if (itemStack == null) {
            return;
        }
        if (!(itemStack.getItem() instanceof FilterItem)) {
            CCGUtil.displayMessage(CCGLang.translate("message.notFilter", new Object[0]).style(ChatFormatting.RED));
            CCGUtil.playSound(AllSoundEvents.DENY);
            return;
        }
        mc.setScreen((Screen)Map.of((Item)AllItems.FILTER.get(), (id, inv, stack) -> new FilterScreen(FilterMenu.create((int)id, (Inventory)inv, (ItemStack)stack), inv, stack.getHoverName()), (Item)AllItems.ATTRIBUTE_FILTER.get(), (id, inv, stack) -> new AttributeFilterScreen(AttributeFilterMenu.create((int)id, (Inventory)inv, (ItemStack)stack), inv, stack.getHoverName()), (Item)AllItems.PACKAGE_FILTER.get(), (id, inv, stack) -> new PackageFilterScreen(PackageFilterMenu.create((int)id, (Inventory)inv, (ItemStack)stack), inv, stack.getHoverName())).get(itemStack.getItem()).apply((Object)-1, (Object)player.getInventory(), (Object)itemStack));
        CCGUtil.playSound(SoundEvents.BOOK_PAGE_TURN);
    }
}

