/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.IItemRenderable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayRenderer {
    public static final Map<Object, Outliner.OutlineEntry> outlines = Outliner.getInstance().getOutlines();
    public static int hoverTicks;
    public static float fade;
    public static ItemStack currentItemStack;

    public static void registerLayer(@NotNull RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"create_cyber_goggles", (String)"goggle_overlay"), OverlayRenderer::renderOverlay);
    }

    public static void tickColor(@NotNull RenderTooltipEvent.Color event) {
        Color colorBackground;
        if (!event.getItemStack().equals(currentItemStack)) {
            return;
        }
        CClient cfg = AllConfigs.client();
        Color color = colorBackground = (Boolean)cfg.overlayCustomColor.get() != false ? new Color(((Integer)cfg.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
        if (fade < 1.0f) {
            colorBackground.scaleAlpha(fade);
        }
        event.setBackground(colorBackground.getRGB());
    }

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ItemStack itemStack;
        if (!CCG.CONFIG.goggles.renderExtraItems || !CCG.CONFIG.gameMode.enableGoggle) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused() || mc.screen != null || mc.options.hideGui) {
            currentItemStack = null;
            hoverTicks = 0;
            return;
        }
        if (!CCG.CONFIG.goggles.canRenderOnValueBox) {
            for (Outliner.OutlineEntry entry : outlines.values()) {
                Outline outline;
                if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
                return;
            }
        }
        fade = Mth.clamp((float)(((float)hoverTicks++ + deltaTracker.getGameTimeDeltaPartialTick(false)) / 24.0f), (float)0.0f, (float)1.0f);
        currentItemStack = itemStack = OverlayRenderer.toRenderItemStack();
        if (itemStack == null) {
            hoverTicks = 0;
            return;
        }
        OverlayRenderer.renderItemStack(guiGraphics, itemStack);
    }

    @Nullable
    public static ItemStack toRenderItemStack() {
        BlockEntity blockEntity = CCGUtil.getBE();
        if (blockEntity instanceof IItemRenderable) {
            IItemRenderable iri = (IItemRenderable)blockEntity;
            return iri.ccg$getItemStack();
        }
        blockEntity = CCGUtil.getE();
        if (blockEntity instanceof IItemRenderable) {
            IItemRenderable iri = (IItemRenderable)blockEntity;
            return iri.ccg$getItemStack();
        }
        return null;
    }

    public static void renderItemStack(GuiGraphics guiGraphics, ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        TooltipFlag.Default tooltipFlag = new TooltipFlag.Default(mc.options.advancedItemTooltips, true);
        List tooltipLines = itemStack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)tooltipFlag);
        int n = tooltipLines.size();
        Objects.requireNonNull(font);
        int height = n * 9;
        CClient cfg = AllConfigs.client();
        int offsetX = fade < 1.0f ? (int)(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5f) * 8.0) : 0;
        int x = guiGraphics.guiWidth() / 2 + (Integer)cfg.overlayOffsetX.get() + offsetX;
        int y = guiGraphics.guiHeight() / 2 + (Integer)cfg.overlayOffsetY.get();
        if (GoggleOverlayRenderer.hoverTicks != 0) {
            y -= height + 20;
        }
        guiGraphics.renderItem(itemStack, x - 10, y - 10);
        guiGraphics.renderItemDecorations(font, itemStack, x - 10, y - 10);
        guiGraphics.renderTooltip(font, itemStack, x, y);
    }
}

