/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.armor.CardboardArmorItem;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import io.github.forgestove.create_cyber_goggles.CCG;
import java.util.stream.Stream;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CCGUtil {
    public static boolean testForStealth(LocalPlayer player) {
        boolean allMatch = Stream.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET).allMatch(slot -> player.getItemBySlot(slot).getItem() instanceof CardboardArmorItem);
        return CCG.CONFIG.chainConveyor.cardBoardedYourself && !player.getAbilities().flying && allMatch;
    }

    @Nullable
    public static KineticBlockEntity getKBE() {
        BlockEntity blockEntity = CCGUtil.getBE();
        if (!(blockEntity instanceof KineticBlockEntity)) {
            return null;
        }
        KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
        return kbe;
    }

    @Nullable
    public static BlockEntity getBE() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return null;
        }
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult bhr = (BlockHitResult)hitResult;
        return bhr.getType() == HitResult.Type.BLOCK ? mc.level.getBlockEntity(bhr.getBlockPos()) : null;
    }

    @Nullable
    public static Entity getE() {
        Minecraft mc = Minecraft.getInstance();
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof EntityHitResult)) {
            return null;
        }
        EntityHitResult ehr = (EntityHitResult)hitResult;
        return ehr.getType() == HitResult.Type.ENTITY ? ehr.getEntity() : null;
    }

    @Nullable
    public static Block getB() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return null;
        }
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        return mc.level.getBlockState(blockHitResult.getBlockPos()).getBlock();
    }

    @Nullable
    public static ItemStack getRelevantFilterItem() {
        SmartBlockEntity sbe;
        BlockEntity blockEntity;
        block6: {
            block5: {
                Minecraft mc = Minecraft.getInstance();
                if (mc.screen != null) {
                    Screen screen = mc.screen;
                    if (!(screen instanceof AbstractContainerScreen)) {
                        return null;
                    }
                    AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                    Slot slot = screen2.getSlotUnderMouse();
                    return slot == null ? null : slot.getItem();
                }
                blockEntity = CCGUtil.getBE();
                if (!(blockEntity instanceof SmartBlockEntity)) break block5;
                sbe = (SmartBlockEntity)blockEntity;
                blockEntity = mc.hitResult;
                if (blockEntity instanceof BlockHitResult) break block6;
            }
            return null;
        }
        BlockHitResult blockHitResult = (BlockHitResult)blockEntity;
        FilteringBehaviour behaviour = (FilteringBehaviour)sbe.getBehaviour(FilteringBehaviour.TYPE);
        return behaviour == null ? ItemStack.EMPTY : behaviour.getFilter(blockHitResult.getDirection());
    }

    public static void displayMessage(LangBuilder builder) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.displayClientMessage((Component)builder.component(), true);
        }
    }

    public static void playSound(SoundEvent sound, float pitch, float volume) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void playSound(AllSoundEvents.SoundEntry entry) {
        CCGUtil.playSound(entry.getMainEvent(), 0.25f, 1.0f);
    }

    public static void playSound(SoundEvent sound) {
        CCGUtil.playSound(sound, 1.0f, 1.0f);
    }

    @Nullable
    public static AABB getBounds(BlockPos blockPos) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        VoxelShape shape = level.getBlockState(blockPos).getShape((BlockGetter)level, blockPos);
        return (shape.isEmpty() ? Shapes.block() : shape).bounds().move(blockPos);
    }
}

