/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.event;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.Common;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class KineticDebugger {
    public static class_2338 lastSource;
    public static List<KineticBlockEntity> cachedKBEPath;

    public static void tick(WorldRenderContext context) {
        if (!CCG.CONFIG.misc.rainbowDebug) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.method_1493() || mc.field_1755 != null) {
            return;
        }
        class_638 level = mc.field_1687;
        if (level == null) {
            return;
        }
        KineticBlockEntity kbe = Common.getKBE();
        if (kbe == null) {
            return;
        }
        KineticDebugger.renderAxisLine(kbe);
        KineticDebugger.updateKBEPath(level, kbe);
        KineticDebugger.renderKineticPath(level, cachedKBEPath, level.method_8510(), context.frustum());
    }

    public static void updateKBEPath(class_638 level, @NotNull KineticBlockEntity kbe) {
        if (kbe.source == lastSource && cachedKBEPath != null) {
            return;
        }
        ArrayDeque<KineticBlockEntity> kbePath = new ArrayDeque<KineticBlockEntity>();
        KineticBlockEntity currentBE = kbe;
        while (currentBE != null) {
            KineticBlockEntity kbeSource;
            kbePath.addFirst(currentBE);
            if (currentBE.source == null) break;
            class_2586 class_25862 = level.method_8321(currentBE.source);
            currentBE = class_25862 instanceof KineticBlockEntity ? (kbeSource = (KineticBlockEntity)class_25862) : null;
        }
        cachedKBEPath = new ArrayList<KineticBlockEntity>(kbePath);
        lastSource = kbe.source;
    }

    public static void renderKineticPath(class_638 level, @NotNull List<KineticBlockEntity> kbePath, long time, class_4604 frustum) {
        for (int depth = 0; depth < kbePath.size(); ++depth) {
            KineticBlockEntity nodeBE = kbePath.get(depth);
            int rgb = KineticDebugger.getRainbowColor(depth, time);
            if (KineticDebugger.isAABBInFrustum(nodeBE, level, frustum)) {
                KineticDebugger.renderOutline(nodeBE, level, depth, rgb);
            }
            if (nodeBE.source == null || !KineticDebugger.isLineInFrustum((class_2382)nodeBE.method_11016(), (class_2382)nodeBE.source, frustum)) continue;
            KineticDebugger.renderKineticLine(nodeBE, depth, rgb);
        }
    }

    public static boolean isAABBInFrustum(@NotNull KineticBlockEntity kbe, @NotNull class_638 level, class_4604 frustum) {
        class_2338 pos = kbe.method_11016();
        class_265 shape = level.method_8320(pos).method_26222((class_1922)level, pos);
        if (shape.method_1110()) {
            return false;
        }
        return frustum.method_23093(shape.method_1107().method_996(pos));
    }

    public static boolean isLineInFrustum(class_2382 start, class_2382 end, @NotNull class_4604 frustum) {
        return frustum.method_23093(new class_238(VecHelper.getCenterOf((class_2382)start), VecHelper.getCenterOf((class_2382)end)));
    }

    public static void renderOutline(@NotNull KineticBlockEntity kbe, @NotNull class_638 level, int depth, int rgb) {
        class_2338 blockPos = kbe.method_11016();
        class_265 shape = level.method_8320(blockPos).method_26222((class_1922)level, blockPos);
        if (kbe.getTheoreticalSpeed() == 0.0f || shape.method_1110()) {
            return;
        }
        CreateClient.OUTLINER.chaseAABB((Object)("KineticOutline" + depth), shape.method_1107().method_996(blockPos)).lineWidth(0.0625f).colored(rgb);
    }

    public static int getRainbowColor(int depth, long time) {
        return Color.HSBtoRGB(1.0f - ((float)depth * 0.05f - (float)(time % 200L) / 100.0f) % 1.0f, 0.8f, 1.0f);
    }

    public static void renderKineticLine(@NotNull KineticBlockEntity kbe, int depth, int rgb) {
        class_2338 end;
        if (kbe.source == null) {
            return;
        }
        class_2338 start = kbe.method_11016();
        if (start.method_19455((class_2382)(end = kbe.source)) == 1) {
            return;
        }
        CreateClient.OUTLINER.showLine((Object)("KineticLine" + depth), VecHelper.getCenterOf((class_2382)start), VecHelper.getCenterOf((class_2382)end)).lineWidth(0.125f).colored(rgb);
    }

    public static void renderAxisLine(@NotNull KineticBlockEntity kbe) {
        class_2680 state = kbe.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof IRotate)) {
            return;
        }
        IRotate iRotate = (IRotate)class_22482;
        class_243 vec = class_243.method_24954((class_2382)class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)iRotate.getRotationAxis(state)).method_10163());
        class_243 center = VecHelper.getCenterOf((class_2382)kbe.method_11016());
        CreateClient.OUTLINER.showLine((Object)"RotationAxis", center.method_1019(vec), center.method_1020(vec)).lineWidth(0.125f);
    }
}

