/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.goggles;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGConfig;
import io.github.forgestove.create_cyber_goggles.event.CCGKey;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={KineticBlockEntity.class}, remap=false)
public abstract class KineticBlockEntityMixin {
    @Shadow
    protected float capacity;
    @Shadow
    protected float stress;
    @Shadow
    protected float speed;
    @Shadow
    protected boolean overStressed;

    @Inject(method={"addToGoggleTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    public void addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> returnable) {
        float stressAtBase;
        CCGConfig.Goggles goggles = CCG.CONFIG.goggles;
        if (!goggles.enhancedInfo) {
            return;
        }
        boolean hide = !goggles.hideStaticKineticInfo || !class_3532.method_15347((float)this.speed, (float)0.0f);
        returnable.setReturnValue((Object)hide);
        if (!hide) {
            return;
        }
        if (IRotate.StressImpact.isEnabled() && !class_3532.method_15347((float)(stressAtBase = this.calculateStressApplied()), (float)0.0f)) {
            this.addStressImpactStats(tooltip, stressAtBase);
        }
        Lang.translate((String)"gui.goggles.kinetic_stats", (Object[])new Object[0]).forGoggles(tooltip);
        IRotate.SpeedLevel.getFormattedSpeedText((float)this.speed, (boolean)this.overStressed).forGoggles(tooltip);
        if (!CCGKey.showStress.isKeyDown()) {
            return;
        }
        double stressFraction = this.stress / (this.capacity == 0.0f ? 1.0f : this.capacity);
        Lang.translate((String)"gui.stressometer.title", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        if (this.speed == 0.0f) {
            Lang.text((String)TooltipHelper.makeProgressBar((int)3, (int)0)).translate("gui.stressometer.no_rotation", new Object[0]).style(class_124.field_1063).forGoggles(tooltip);
        } else {
            IRotate.StressImpact.getFormattedStressText((double)stressFraction).forGoggles(tooltip);
            Lang.translate((String)"gui.stressometer.capacity", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            double remainingCapacity = this.capacity - this.stress;
            LangBuilder su = Lang.translate((String)"generic.unit.stress", (Object[])new Object[0]);
            LangBuilder stressTip = Lang.number((double)remainingCapacity).add(su).style(IRotate.StressImpact.of((double)stressFraction).getRelativeColor());
            if (remainingCapacity != (double)this.capacity) {
                stressTip.text(class_124.field_1080, " / ").add(Lang.number((double)this.capacity).add(su).style(class_124.field_1063));
            }
            stressTip.forGoggles(tooltip, 1);
        }
    }

    @Shadow
    public abstract float calculateStressApplied();

    @Shadow
    protected abstract void addStressImpactStats(List<class_2561> var1, float var2);
}

