/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.chassis.LinearChassisBlock;
import com.simibubi.create.content.contraptions.wrench.RadialWrenchMenuSubmitPacket;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.event.CCGKey;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import java.util.ArrayList;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PlayerInteract {
    private static long lastDismantleTime;
    private static long dismantleDelay;

    public static void tick(TickEvent.ClientTickEvent ignoredEvent) {
        PlayerInteract.wrench();
        PlayerInteract.encasedCogWheel();
        PlayerInteract.enacesdPipe();
        PlayerInteract.chassis();
    }

    public static void leftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (CCGUtil.isServer()) {
            return;
        }
        PlayerInteract.wrench(event);
    }

    public static void rightClick(PlayerInteractEvent.RightClickBlock event) {
        if (CCGUtil.isServer()) {
            return;
        }
        PlayerInteract.enacesdPipe(event);
        PlayerInteract.encasedCogWheel(event);
        PlayerInteract.chassis(event);
    }

    private static void wrench() {
        if (dismantleDelay < 10L) {
            ++dismantleDelay;
        }
    }

    private static void wrench(PlayerInteractEvent.LeftClickBlock event) {
        InteractionHand handWithWrench;
        boolean canDismantle;
        if (!CCG.CONFIG.wrench.leftClickFastDismantle) {
            return;
        }
        if (dismantleDelay > 0L) {
            --dismantleDelay;
        }
        boolean bl = canDismantle = System.currentTimeMillis() - lastDismantleTime > dismantleDelay * 20L;
        if (!canDismantle) {
            return;
        }
        PlayerInteractEvent.LeftClickBlock.Action action = event.getAction();
        if (action != PlayerInteractEvent.LeftClickBlock.Action.START && action != PlayerInteractEvent.LeftClickBlock.Action.CLIENT_HOLD) {
            return;
        }
        LocalPlayer player = CCGUtil.mc.f_91074_;
        if (player == null || CCGUtil.mc.f_91074_.m_7500_() || CCGUtil.mc.f_91072_ == null) {
            return;
        }
        Object object = player.m_21205_().m_41720_() instanceof WrenchItem ? InteractionHand.MAIN_HAND : (handWithWrench = player.m_21206_().m_41720_() instanceof WrenchItem ? InteractionHand.OFF_HAND : null);
        if (handWithWrench == null) {
            return;
        }
        if (!(CCGUtil.getBlock() instanceof IWrenchable)) {
            return;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null) {
            return;
        }
        CCGUtil.sendAction(ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY);
        CCGUtil.mc.f_91072_.m_233732_(player, handWithWrench, result);
        CCGUtil.sendAction(ServerboundPlayerCommandPacket.Action.RELEASE_SHIFT_KEY);
        lastDismantleTime = System.currentTimeMillis();
        event.setCanceled(true);
    }

    private static void encasedCogWheel() {
        if (!CCG.CONFIG.wrench.betterEncasedCogwheel) {
            return;
        }
        Block block = CCGUtil.getBlock();
        if (!(block instanceof EncasedCogwheelBlock)) {
            return;
        }
        EncasedCogwheelBlock ecb = (EncasedCogwheelBlock)block;
        BlockHitResult bhr = CCGUtil.getBlockHitResult();
        if (CCGUtil.mc.f_91073_ == null || bhr == null) {
            return;
        }
        if (ecb.getRotationAxis(CCGUtil.mc.f_91073_.m_8055_(bhr.m_82425_())) != bhr.m_82434_().m_122434_()) {
            return;
        }
        PlayerInteract.showCommonTip("message.openState");
    }

    private static void encasedCogWheel(PlayerInteractEvent.RightClickBlock event) {
        if (!CCG.CONFIG.wrench.betterEncasedCogwheel) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().m_8055_(pos);
        if (!(state.m_60734_() instanceof EncasedCogwheelBlock) || event.getHand() != InteractionHand.MAIN_HAND || CCGUtil.mc.f_91074_ == null || CCGUtil.hasItemInHand()) {
            return;
        }
        Direction clickedFace = event.getHitVec().m_82434_();
        if (CCGKey.interactOpposite.isDown()) {
            clickedFace = clickedFace.m_122424_();
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
        if (clickedFace.m_122434_() != axis) {
            return;
        }
        BooleanProperty booleanProperty = clickedFace.m_122421_() == Direction.AxisDirection.POSITIVE ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT;
        CCGUtil.sendToServer((SimplePacketBase)new RadialWrenchMenuSubmitPacket(pos, (BlockState)state.m_61122_((Property)booleanProperty)));
        CCGUtil.mc.f_91074_.m_6674_(CCGUtil.mc.f_91074_.m_7655_());
    }

    private static void enacesdPipe() {
        if (!CCG.CONFIG.wrench.betterEncasedPipe) {
            return;
        }
        if (!(CCGUtil.getBlock() instanceof EncasedPipeBlock)) {
            return;
        }
        PlayerInteract.showCommonTip("message.openState");
    }

    private static void enacesdPipe(PlayerInteractEvent.RightClickBlock event) {
        if (!CCG.CONFIG.wrench.betterEncasedPipe) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().m_8055_(pos);
        if (!(state.m_60734_() instanceof EncasedPipeBlock) || event.getHand() != InteractionHand.MAIN_HAND || CCGUtil.mc.f_91074_ == null || CCGUtil.hasItemInHand()) {
            return;
        }
        Direction clickedFace = event.getHitVec().m_82434_();
        if (CCGKey.interactOpposite.isDown()) {
            clickedFace = clickedFace.m_122424_();
        }
        BooleanProperty booleanProperty = (BooleanProperty)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(clickedFace);
        CCGUtil.sendToServer((SimplePacketBase)new RadialWrenchMenuSubmitPacket(pos, (BlockState)state.m_61122_((Property)booleanProperty)));
        CCGUtil.mc.f_91074_.m_6674_(CCGUtil.mc.f_91074_.m_7655_());
    }

    private static void chassis() {
        if (!CCG.CONFIG.wrench.betterChassis) {
            return;
        }
        if (CCGUtil.mc.f_91073_ == null) {
            return;
        }
        Block block = CCGUtil.getBlock();
        if (!(block instanceof AbstractChassisBlock)) {
            return;
        }
        AbstractChassisBlock acb = (AbstractChassisBlock)block;
        BlockHitResult bhr = CCGUtil.getBlockHitResult();
        if (bhr == null || acb.getGlueableSide(CCGUtil.mc.f_91073_.m_8055_(bhr.m_82425_()), bhr.m_82434_()) == null) {
            return;
        }
        PlayerInteract.showCommonTip("message.glueState");
    }

    private static void chassis(PlayerInteractEvent.RightClickBlock event) {
        BooleanProperty booleanProperty;
        if (!CCG.CONFIG.wrench.betterChassis) {
            return;
        }
        if (CCGUtil.hasActivedValueBox()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof AbstractChassisBlock)) {
            return;
        }
        AbstractChassisBlock acb = (AbstractChassisBlock)block;
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (CCGUtil.mc.f_91074_ == null) {
            return;
        }
        if (CCGUtil.mc.f_91074_.m_6144_()) {
            return;
        }
        if (!CCGUtil.hasItemInHand()) {
            return;
        }
        Direction clickedFace = event.getHitVec().m_82434_();
        boolean oppositeMode = CCGKey.interactOpposite.isDown();
        if (oppositeMode) {
            clickedFace = clickedFace.m_122424_();
            Level level = event.getLevel();
            EnumProperty axisProp = RotatedPillarBlock.f_55923_;
            Direction.Axis baseAxis = state.m_61138_((Property)axisProp) ? (Direction.Axis)state.m_61143_((Property)axisProp) : null;
            BlockPos probePos = pos.m_121945_(clickedFace);
            BlockState probeState = level.m_8055_(probePos);
            AbstractChassisBlock targetAcb = acb;
            if (state.m_60734_() instanceof LinearChassisBlock) {
                Block block2;
                while ((block2 = probeState.m_60734_()) instanceof LinearChassisBlock) {
                    Direction.Axis probeAxis;
                    LinearChassisBlock lcb = (LinearChassisBlock)block2;
                    Direction.Axis axis = probeAxis = probeState.m_61138_((Property)axisProp) ? (Direction.Axis)probeState.m_61143_((Property)axisProp) : null;
                    if (probeAxis == null || probeAxis != baseAxis) break;
                    pos = probePos;
                    state = probeState;
                    targetAcb = lcb;
                    probePos = probePos.m_121945_(clickedFace);
                    probeState = level.m_8055_(probePos);
                }
            }
            acb = targetAcb;
        }
        if ((booleanProperty = acb.getGlueableSide(state, clickedFace)) == null) {
            return;
        }
        CCGUtil.sendToServer((SimplePacketBase)new RadialWrenchMenuSubmitPacket(pos, (BlockState)state.m_61122_((Property)booleanProperty)));
        CCGUtil.mc.f_91074_.m_6674_(CCGUtil.mc.f_91074_.m_7655_());
    }

    private static void showCommonTip(String title) {
        if (CCGUtil.hasActivedValueBox()) {
            return;
        }
        if (CCGUtil.hasItemInHand()) {
            return;
        }
        ArrayList tip = new ArrayList();
        CCGLang.translate(title, new Object[0]).addTo(tip);
        CCGLang.translate("message.useSwitchState", CCGKey.getColoredDisplayName(CCGUtil.mc.f_91066_.f_92095_)).addTo(tip);
        CCGLang.translate("message.pressToInteractOpposite", CCGKey.interactOpposite.getColoredDisplayName()).addTo(tip);
        CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip(tip);
    }

    static {
        dismantleDelay = 10L;
    }
}

