/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.goggles;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.forgestove.create_cyber_goggles.CCG;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FilterItem.class}, remap=false)
public abstract class FilterItemMixin {
    @Inject(method={"makeSummary"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeSummary(ItemStack filter, CallbackInfoReturnable<List<Component>> returnable) {
        String address;
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        if (!filter.m_41782_()) {
            returnable.setReturnValue(list);
            return;
        }
        if (filter.m_41720_().equals(AllItems.FILTER.get())) {
            ItemStackHandler filterItems = FilterItem.getFilterItems((ItemStack)filter);
            boolean blacklist = filter.m_41784_().m_128471_("Blacklist");
            list.add((blacklist ? CreateLang.translateDirect((String)"gui.filter.deny_list", (Object[])new Object[0]) : CreateLang.translateDirect((String)"gui.filter.allow_list", (Object[])new Object[0])).m_130940_(ChatFormatting.GOLD));
            int count = 0;
            for (int i = 0; i < filterItems.getSlots(); ++i) {
                ItemStack filterStack = filterItems.getStackInSlot(i);
                if (filterStack.m_41619_()) continue;
                list.add(Component.m_237113_((String)"- ").m_7220_(filterStack.m_41786_()).m_130940_(ChatFormatting.GRAY));
                ++count;
            }
            if (count == 0) {
                returnable.setReturnValue(Collections.emptyList());
                return;
            }
        } else if (filter.m_41720_().equals(AllItems.ATTRIBUTE_FILTER.get())) {
            AttributeFilterMenu.WhitelistMode whitelistMode = AttributeFilterMenu.WhitelistMode.values()[filter.m_41784_().m_128451_("WhitelistMode")];
            list.add((whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_CONJ ? CreateLang.translateDirect((String)"gui.attribute_filter.allow_list_conjunctive", (Object[])new Object[0]) : (whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ ? CreateLang.translateDirect((String)"gui.attribute_filter.allow_list_disjunctive", (Object[])new Object[0]) : CreateLang.translateDirect((String)"gui.attribute_filter.deny_list", (Object[])new Object[0]))).m_130940_(ChatFormatting.GOLD));
            int count = 0;
            for (Tag inbt : filter.m_41784_().m_128437_("MatchedAttributes", 10)) {
                CompoundTag compound = (CompoundTag)inbt;
                ItemAttribute attribute = ItemAttribute.loadStatic((CompoundTag)compound);
                if (attribute == null) continue;
                boolean inverted = compound.m_128471_("Inverted");
                list.add(Component.m_237113_((String)"- ").m_7220_((Component)attribute.format(inverted)));
                ++count;
            }
            if (count == 0) {
                returnable.setReturnValue(Collections.emptyList());
                return;
            }
        } else if (filter.m_41720_().equals(AllItems.PACKAGE_FILTER.get()) && !(address = PackageItem.getAddress((ItemStack)filter)).isBlank()) {
            list.add(CreateLang.text((String)"-> ").style(ChatFormatting.GRAY).add(CreateLang.text((String)address).style(ChatFormatting.GOLD)).component());
        }
        returnable.setReturnValue(list);
    }
}

