/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.provider;

import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.GoggleTooltipUtil;
import io.github.forgestove.create_cyber_goggles.core.util.Self;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BacktankBlockEntity.class}, remap=false)
public abstract class BacktankBlockEntityMixin
extends KineticBlockEntity
implements IHaveGoggleInformation,
Self<BacktankBlockEntity> {
    @Unique
    public int ccg$leftTick;
    @Unique
    public int ccg$prevAirLevel;
    @Shadow
    public int airLevel;
    @Shadow
    public int airLevelTimer;
    @Shadow
    private int capacityEnchantLevel;

    public BacktankBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean thiz = GoggleTooltipUtil.backtank(tooltip, (BacktankBlockEntity)this.self(), this.capacityEnchantLevel, this.ccg$leftTick);
        boolean sup = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return thiz || sup;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN", ordinal=3)})
    public void tick(CallbackInfo ci, @Local(name={"max"}) int max) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        if (this.airLevel == max) {
            return;
        }
        this.ccg$prevAirLevel = this.airLevel;
        float abs = Math.abs(this.getSpeed());
        int increment = Mth.m_14045_((int)(((int)abs - 100) / 20), (int)1, (int)5);
        this.airLevel = Math.min(max, this.airLevel + increment);
        this.airLevelTimer = Mth.m_14045_((int)((int)(128.0f - abs / 5.0f) - 108), (int)0, (int)20);
        this.ccg$leftTick = (max - this.airLevel) / increment * Math.max(1, this.airLevelTimer);
    }

    @ModifyVariable(method={"read"}, at=@At(value="STORE"), name={"prev"})
    private int modifyPrev(int prev) {
        return this.ccg$prevAirLevel;
    }
}

