/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.event;

import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.BeltInventory;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlockEntity;
import com.simibubi.create.content.kinetics.millstone.MillstoneBlockEntity;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.content.logistics.crate.CreativeCrateBlockEntity;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGUtil;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.CreativeCrateBlockEntityAccessor;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayRenderer {
    public static int hoverTicks;
    public static float fade;
    public static ItemStack currentItemStack;
    public static ItemStack cannonItemStack;

    public static void registerLayer(@NotNull RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"create_cyber_goggles", (String)"goggle_overlay"), OverlayRenderer::renderOverlay);
    }

    public static void tickColor(@NotNull RenderTooltipEvent.Color event) {
        Color colorBackground;
        if (!event.getItemStack().equals(currentItemStack)) {
            return;
        }
        CClient cfg = AllConfigs.client();
        Color color = colorBackground = (Boolean)cfg.overlayCustomColor.get() != false ? new Color(((Integer)cfg.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
        if (fade < 1.0f) {
            colorBackground.scaleAlpha(fade);
        }
        event.setBackground(colorBackground.getRGB());
    }

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ItemStack itemStack;
        if (!CCG.CONFIG.goggles.renderExtraItems) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused() || mc.screen != null || mc.options.hideGui) {
            currentItemStack = null;
            hoverTicks = 0;
            return;
        }
        fade = Mth.clamp((float)(((float)hoverTicks++ + deltaTracker.getGameTimeDeltaPartialTick(false)) / 24.0f), (float)0.0f, (float)1.0f);
        currentItemStack = itemStack = OverlayRenderer.toRenderItemStack();
        if (itemStack == null) {
            hoverTicks = 0;
            return;
        }
        OverlayRenderer.renderItemStack(guiGraphics, itemStack);
    }

    @Nullable
    public static ItemStack toRenderItemStack() {
        BlockEntity be = CCGUtil.getBE();
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity dbe = (DepotBlockEntity)be;
            return dbe.getHeldItem();
        }
        if (be instanceof EjectorBlockEntity) {
            EjectorBlockEntity ebe = (EjectorBlockEntity)be;
            return ((DepotBehaviour)ebe.getBehaviour(DepotBehaviour.TYPE)).getHeldItemStack();
        }
        if (be instanceof PackagerBlockEntity) {
            PackagerBlockEntity pbe = (PackagerBlockEntity)be;
            return pbe.heldBox;
        }
        if (be instanceof ChuteBlockEntity) {
            ChuteBlockEntity cbe = (ChuteBlockEntity)be;
            return cbe.getItem();
        }
        if (be instanceof MechanicalCrafterBlockEntity) {
            MechanicalCrafterBlockEntity mcbe = (MechanicalCrafterBlockEntity)be;
            return mcbe.getInventory().getItem(0);
        }
        if (be instanceof CrushingWheelControllerBlockEntity) {
            CrushingWheelControllerBlockEntity cwcb = (CrushingWheelControllerBlockEntity)be;
            return cwcb.inventory.getStackInSlot(0);
        }
        if (be instanceof MillstoneBlockEntity) {
            MillstoneBlockEntity mbe = (MillstoneBlockEntity)be;
            return mbe.inputInv.getStackInSlot(0);
        }
        if (be instanceof CreativeCrateBlockEntity) {
            CreativeCrateBlockEntity ccbe = (CreativeCrateBlockEntity)be;
            return ((CreativeCrateBlockEntityAccessor)ccbe).getFiltering().getFilter();
        }
        if (be instanceof SchematicannonBlockEntity) {
            SchematicannonBlockEntity sbe = (SchematicannonBlockEntity)be;
            return sbe.state.equals((Object)SchematicannonBlockEntity.State.STOPPED) ? null : cannonItemStack;
        }
        if (be instanceof BeltBlockEntity) {
            BeltBlockEntity bbe = (BeltBlockEntity)be;
            BeltInventory inventory = bbe.getInventory();
            if (inventory == null) {
                return null;
            }
            TransportedItemStack stackAtOffset = inventory.getStackAtOffset(bbe.index);
            return stackAtOffset == null ? null : stackAtOffset.stack;
        }
        Entity e = CCGUtil.getE();
        if (e instanceof PackageEntity) {
            PackageEntity pe = (PackageEntity)e;
            return pe.getBox();
        }
        return null;
    }

    public static void renderItemStack(GuiGraphics guiGraphics, ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        TooltipFlag.Default tooltipFlag = mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        List tooltipLines = itemStack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)tooltipFlag);
        int n = tooltipLines.size();
        Objects.requireNonNull(font);
        int height = n * 9;
        CClient cfg = AllConfigs.client();
        int offsetX = fade < 1.0f ? (int)(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5f) * 8.0) : 0;
        int x = guiGraphics.guiWidth() / 2 + (Integer)cfg.overlayOffsetX.get() + offsetX;
        int y = guiGraphics.guiHeight() / 2 + (Integer)cfg.overlayOffsetY.get();
        if (GoggleOverlayRenderer.hoverTicks != 0) {
            y -= height + 20;
        }
        guiGraphics.renderItem(itemStack, x - 10, y - 10);
        guiGraphics.renderItemDecorations(font, itemStack, x - 10, y - 10);
        guiGraphics.renderTooltip(font, itemStack, x, y);
    }
}

