/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.goggles;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.logistics.box.PackageItem;
import io.github.forgestove.create_cyber_goggles.CCG;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PackageItem.class})
public abstract class PackageItemMixin
extends Item {
    public PackageItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltipComponents, TooltipFlag tooltipFlag, CallbackInfo ci) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        ci.cancel();
        super.appendHoverText(stack, tooltipContext, tooltipComponents, tooltipFlag);
        if (stack.has(AllDataComponents.PACKAGE_ADDRESS)) {
            tooltipComponents.add((Component)Component.literal((String)("\u2192 " + (String)stack.get(AllDataComponents.PACKAGE_ADDRESS))).withStyle(ChatFormatting.GOLD));
        }
        if (!stack.has(AllDataComponents.PACKAGE_CONTENTS)) {
            return;
        }
        ItemStackHandler contents = PackageItem.getContents((ItemStack)stack);
        for (int i = 0; i < contents.getSlots(); ++i) {
            ItemStack itemstack = contents.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            tooltipComponents.add((Component)itemstack.getHoverName().copy().append(" x" + itemstack.getCount()).withStyle(ChatFormatting.GRAY));
        }
    }
}

