/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.goggles;

import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.KineticTooltipBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.SpeedGaugeTooltipBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.StressGaugeTooltipBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.TooltipBehaviour;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGConfig;
import io.github.forgestove.create_cyber_goggles.event.CCGKey;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.KineticBlockEntityAccessor;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={KineticTooltipBehaviour.class}, remap=false)
public abstract class KineticBlockEntityMixin<T extends KineticBlockEntity>
extends TooltipBehaviour<T> {
    public KineticBlockEntityMixin(T be) {
        super(be);
    }

    @Inject(method={"addToGoggleTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    public void addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> returnable) {
        float stressAtBase;
        CCGConfig.Goggles goggles = CCG.CONFIG.goggles;
        if (!goggles.enhancedInfo) {
            return;
        }
        boolean hide = !goggles.hideStaticKineticInfo || !class_3532.method_15347((float)((KineticBlockEntity)this.blockEntity).getTheoreticalSpeed(), (float)0.0f);
        returnable.setReturnValue((Object)hide);
        if (!hide) {
            return;
        }
        if (IRotate.StressImpact.isEnabled() && !class_3532.method_15347((float)(stressAtBase = ((KineticBlockEntity)this.blockEntity).calculateStressApplied()), (float)0.0f)) {
            this.addStressImpactStats(tooltip, stressAtBase);
        }
        CreateLang.translate((String)"gui.goggles.kinetic_stats", (Object[])new Object[0]).forGoggles(tooltip);
        SpeedGaugeTooltipBehaviour.getFormattedSpeedText((float)((KineticBlockEntity)this.blockEntity).getTheoreticalSpeed(), (boolean)((KineticBlockEntity)this.blockEntity).isOverStressed()).forGoggles(tooltip);
        if (!CCGKey.showStress.keyMapping.method_1434()) {
            return;
        }
        KineticBlockEntityAccessor accessor = (KineticBlockEntityAccessor)this.blockEntity;
        float stress = accessor.getStress();
        float capacity = accessor.getCapacity();
        double stressFraction = stress / (capacity == 0.0f ? 1.0f : capacity);
        CreateLang.translate((String)"gui.stressometer.title", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        if (((KineticBlockEntity)this.blockEntity).getTheoreticalSpeed() == 0.0f) {
            CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)0)).translate("gui.stressometer.no_rotation", new Object[0]).style(class_124.field_1063).forGoggles(tooltip);
        } else {
            StressGaugeTooltipBehaviour.getFormattedStressText((double)stressFraction).forGoggles(tooltip);
            CreateLang.translate((String)"gui.stressometer.capacity", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            double remainingCapacity = capacity - stress;
            LangBuilder su = CreateLang.translate((String)"generic.unit.stress", (Object[])new Object[0]);
            LangBuilder stressTip = CreateLang.number((double)remainingCapacity).add(su).style(IRotate.StressImpact.of((double)stressFraction).getRelativeColor());
            if (remainingCapacity != (double)capacity) {
                stressTip.text(class_124.field_1080, " / ").add(CreateLang.number((double)capacity).add(su).style(class_124.field_1063));
            }
            stressTip.forGoggles(tooltip, 1);
        }
    }

    @Shadow
    protected abstract void addStressImpactStats(List<class_2561> var1, float var2);
}

