/*
 * Decompiled with CFR 0.152.
 */
package com.forgestove.create_cyber_goggles.mixin.render;

import com.forgestove.create_cyber_goggles.CreateCyberGoggles;
import com.forgestove.create_cyber_goggles.Util;
import com.forgestove.create_cyber_goggles.event.MouseScroll;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.logistics.tableCloth.BlueprintOverlayShopContext;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlueprintOverlayRenderer.class})
public abstract class BlueprintOverlayRendererMixin {
    @Shadow(remap=false)
    static boolean active;
    @Shadow(remap=false)
    static boolean empty;
    @Shadow(remap=false)
    static List<Pair<ItemStack, Boolean>> ingredients;
    @Shadow(remap=false)
    static List<ItemStack> results;
    @Shadow(remap=false)
    static boolean noOutput;
    @Shadow(remap=false)
    static boolean resultCraftable;
    @Shadow(remap=false)
    static BlueprintOverlayShopContext shopContext;

    @Inject(method={"renderOverlay"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void renderOverlay(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height, CallbackInfo callbackInfo) {
        if (!CreateCyberGoggles.config.goggles.enhancedStoreRender) {
            return;
        }
        callbackInfo.cancel();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91080_ != null) {
            return;
        }
        if (!active || empty) {
            return;
        }
        boolean invalidShop = shopContext != null && (ingredients.isEmpty() || ((ItemStack)ingredients.get(0).getFirst()).m_41619_() || shopContext.stockLevel() == 0);
        int w = 21 * ingredients.size();
        if (!noOutput) {
            w += 21 * results.size();
            w += 30;
        }
        int x = (guiGraphics.m_280182_() - w) / 2;
        int y = guiGraphics.m_280206_() - 100;
        if (shopContext != null) {
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(x - 2), (int)(y + 1), (int)(w + 4), (int)19, (int)0, (int)0x55000000, (int)0x55000000, (int)0, (int)0);
            AllGuiTextures.TRADE_OVERLAY.render(guiGraphics, guiGraphics.m_280182_() / 2 - 48, y - 19);
            if (shopContext.purchases() > 0) {
                guiGraphics.m_280480_(AllItems.SHOPPING_LIST.asStack(), guiGraphics.m_280182_() / 2 + 20, y - 20);
                guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)("x" + shopContext.purchases())), guiGraphics.m_280182_() / 2 + 20 + 16, y - 20 + 4, -1118482, true);
            }
        }
        for (Pair<ItemStack, Boolean> pair : ingredients) {
            RenderSystem.enableBlend();
            ((Boolean)pair.getSecond() != false ? AllGuiTextures.HOTSLOT_ACTIVE : AllGuiTextures.HOTSLOT).render(guiGraphics, x, y);
            ItemStack itemStack = (ItemStack)pair.getFirst();
            String count = shopContext != null && !shopContext.checkout() || (Boolean)pair.getSecond() != false ? null : ChatFormatting.GOLD.toString() + itemStack.m_41613_();
            BlueprintOverlayRenderer.drawItemStack((GuiGraphics)guiGraphics, (Minecraft)mc, (int)x, (int)y, (ItemStack)itemStack, (String)count);
            x += 21;
        }
        if (noOutput) {
            return;
        }
        x += 5;
        RenderSystem.enableBlend();
        if (invalidShop) {
            AllGuiTextures.HOTSLOT_ARROW_BAD.render(guiGraphics, x, y + 4);
        } else {
            AllGuiTextures.HOTSLOT_ARROW.render(guiGraphics, x, y + 4);
        }
        x += 25;
        ResourceLocation hotbarOffHandLeft = ResourceLocation.m_135820_((String)"hud/hotbar_offhand_left");
        ResourceLocation hotbarSelection = ResourceLocation.m_135820_((String)"hud/hotbar_selection");
        if (results.isEmpty()) {
            if (hotbarOffHandLeft != null) {
                guiGraphics.m_280218_(hotbarOffHandLeft, x, y, 0, 0, 24, 23);
            }
            GuiGameElement.of((ItemLike)Items.f_42127_).at((float)(x + 3), (float)(y + 3)).render(guiGraphics);
        } else if (shopContext != null && !shopContext.checkout()) {
            MouseScroll.index += MouseScroll.scrollDeltaY;
            MouseScroll.scrollDeltaY = 0;
            if (MouseScroll.index < 1) {
                MouseScroll.index = results.size();
            } else if (MouseScroll.index > results.size()) {
                MouseScroll.index = 1;
            }
            int selectedX = 0;
            int resultsSize = results.size();
            for (int i = 0; i < resultsSize; ++i) {
                AllGuiTextures slot;
                ItemStack result = results.get(i);
                AllGuiTextures allGuiTextures = slot = resultCraftable ? AllGuiTextures.HOTSLOT_SUPER_ACTIVE : AllGuiTextures.HOTSLOT;
                if (!invalidShop && shopContext != null && shopContext.stockLevel() > shopContext.purchases()) {
                    slot = AllGuiTextures.HOTSLOT_ACTIVE;
                }
                slot.render(guiGraphics, resultCraftable ? x - 1 : x, resultCraftable ? y - 1 : y);
                BlueprintOverlayRenderer.drawItemStack((GuiGraphics)guiGraphics, (Minecraft)mc, (int)x, (int)y, (ItemStack)result, null);
                if (i == MouseScroll.index - 1) {
                    selectedX = x;
                }
                x += 21;
            }
            if (selectedX != 0 && hotbarSelection != null) {
                guiGraphics.m_280218_(hotbarSelection, selectedX - 1, y - 1, 0, 0, 24, 23);
            }
            Util.renderItemStack(guiGraphics, results.get(MouseScroll.index - 1));
        }
        RenderSystem.disableBlend();
    }
}

