/*
 * Decompiled with CFR 0.152.
 */
package com.forgestove.create_cyber_goggles.mixin.screen;

import com.simibubi.create.content.logistics.AddressEditBox;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StockKeeperRequestScreen.class})
public abstract class StockKeeperRequestScreenMixin
extends AbstractSimiContainerScreen<StockKeeperRequestMenu> {
    @Shadow(remap=false)
    public AddressEditBox addressBox;
    @Shadow(remap=false)
    public List<List<BigItemStack>> displayedItems;
    @Shadow(remap=false)
    public List<BigItemStack> itemsToOrder;
    @Shadow(remap=false)
    public List<List<BigItemStack>> currentItemSource;
    @Shadow(remap=false)
    public boolean refreshSearchNextTick;
    @Shadow(remap=false)
    public LerpedFloat itemScroll;
    @Shadow(remap=false)
    public boolean moveToTopNextTick;
    @Shadow(remap=false)
    int emptyTicks;
    @Shadow(remap=false)
    int successTicks;
    @Shadow(remap=false)
    StockTickerBlockEntity blockEntity;
    @Shadow(remap=false)
    private InventorySummary forcedEntries;

    public StockKeeperRequestScreenMixin(StockKeeperRequestMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    @Inject(method={"containerTick"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    protected void containerTick(CallbackInfo callbackInfo) {
        callbackInfo.cancel();
        super.m_181908_();
        this.addressBox.m_94120_();
        if (!this.forcedEntries.isEmpty()) {
            InventorySummary summary = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
            for (BigItemStack bigItemStack : this.forcedEntries.getStacks()) {
                int limitedAmount = -bigItemStack.count - 1;
                int actualAmount = summary.getCountOf(bigItemStack.stack);
                if (actualAmount > limitedAmount) continue;
                this.forcedEntries.erase(bigItemStack.stack);
            }
        }
        boolean allEmpty = true;
        for (List<Object> list : this.displayedItems) {
            allEmpty &= list.isEmpty();
        }
        this.emptyTicks = allEmpty ? ++this.emptyTicks : 0;
        this.successTicks = this.successTicks > 0 && this.itemsToOrder.isEmpty() ? ++this.successTicks : 0;
        List clientStockSnapshot = this.blockEntity.getClientStockSnapshot();
        if (clientStockSnapshot != this.currentItemSource) {
            this.currentItemSource = clientStockSnapshot;
            this.refreshSearchResults(false);
            this.revalidateOrders();
        }
        if (this.refreshSearchNextTick) {
            this.refreshSearchNextTick = false;
            this.refreshSearchResults(this.moveToTopNextTick);
        }
        this.itemScroll.tickChaser();
        if (Math.abs(this.itemScroll.getValue() - this.itemScroll.getChaseTarget()) < 0.0625f) {
            this.itemScroll.setValue((double)this.itemScroll.getChaseTarget());
        }
        this.blockEntity.refreshClientStockSnapshot();
    }

    @Shadow(remap=false)
    private void revalidateOrders() {
    }

    @Shadow(remap=false)
    private void refreshSearchResults(boolean scrollBackUp) {
    }
}

