/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import io.github.forgestove.create_cyber_goggles.core.event.KeyInput;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.Index;
import java.util.List;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableClothUtil {
    public static void clothStoreOverlay(GuiGraphics graphics, int x, int y, @NotNull List<ItemStack> items) {
        TableClothBlockEntity tcbe = CCGUtil.getBlockEntity(TableClothBlockEntity.class);
        if (tcbe == null) {
            return;
        }
        if (items.isEmpty()) {
            AllGuiTextures.HOTSLOT.render(graphics, x, y);
            GuiGameElement.of((ItemLike)Items.BARRIER).at((float)(x + 3), (float)(y + 3)).render(graphics);
            return;
        }
        Integer index = TableClothUtil.getIndex(items, tcbe);
        if (index == null) {
            return;
        }
        int selectedX = x + index * 21;
        AllGuiTextures.HOTSLOT_SUPER_ACTIVE.render(graphics, selectedX - 1, y - 1);
        int resultX = x;
        for (ItemStack item : items) {
            BlueprintOverlayRenderer.drawItemStack((GuiGraphics)graphics, (Minecraft)CCGUtil.mc, (int)resultX, (int)y, (ItemStack)item, null);
            resultX += 21;
        }
    }

    public static void tableOverlay(@NotNull GuiGraphics graphics) {
        TableClothBlockEntity tcbe = CCGUtil.getBlockEntity(TableClothBlockEntity.class);
        if (tcbe == null) {
            return;
        }
        if (tcbe.isShop()) {
            return;
        }
        List<ItemStack> items = TableClothUtil.getItems(tcbe);
        if (items.isEmpty()) {
            return;
        }
        int itemWidth = 21 * items.size();
        int width = graphics.guiWidth();
        int x = (width - itemWidth) / 2;
        int height = graphics.guiHeight();
        int y = height - 100;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)x, (int)y, (int)itemWidth, (int)20, (int)0, (int)0x55000000, (int)0x55000000, (int)0, (int)0);
        Integer index = TableClothUtil.getIndex(items, tcbe);
        if (index == null) {
            return;
        }
        AllGuiTextures.HOTSLOT_SUPER_ACTIVE.render(graphics, x + 2 + index * 21 - 4, y - 2);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack item = items.get(i);
            int itemX = x + 2 + i * 21;
            graphics.renderItem(item, itemX, y + 2);
            graphics.renderItemDecorations(CCGUtil.mc.font, item, itemX, y + 2);
        }
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static Integer getIndex(@NotNull List<ItemStack> items, TableClothBlockEntity tcbe) {
        if (!(tcbe instanceof Index)) {
            return null;
        }
        Index i = (Index)tcbe;
        int index = i.ccg$getIndex() - KeyInput.scrollDeltaY;
        KeyInput.scrollDeltaY = 0;
        int size = items.size();
        if (index < 0) {
            index = size - 1;
        } else if (index >= size) {
            index = 0;
        }
        i.ccg$setIndex(index);
        return index;
    }

    public static List<ItemStack> getItems(@NotNull TableClothBlockEntity tcbe) {
        return tcbe.isShop() ? tcbe.requestData.encodedRequest().stacks().stream().map(bigItemStack -> bigItemStack.stack).toList() : tcbe.manuallyAddedItems;
    }
}

