/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.provider;

import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.content.logistics.depot.EntityLauncher;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.ItemRenderable;
import io.github.forgestove.create_cyber_goggles.core.util.OutlineRenderable;
import io.github.forgestove.create_cyber_goggles.core.util.Self;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EjectorBlockEntity.class})
public abstract class EjectorBlockEntityMixin
implements ItemRenderable,
OutlineRenderable,
Self<EjectorBlockEntity> {
    @Shadow
    DepotBehaviour depotBehaviour;

    @Shadow
    protected abstract Direction getFacing();

    @Shadow
    protected abstract boolean cannotLaunch();

    @Override
    public ItemStack ccg$getItemStack() {
        return this.depotBehaviour.getHeldItemStack();
    }

    @Override
    public void ccg$render() {
        EjectorBlockEntity ebe = (EjectorBlockEntity)this.self();
        BlockPos targetPos = ebe.getTargetPosition();
        BlockPos blockPos = ebe.getBlockPos();
        CCGUtil.outliner.showAABB((Object)("EjectorTargetBox" + String.valueOf(this)), CCGUtil.getBounds(targetPos)).lineWidth(0.0625f).colored(CCG.CONFIG.outliner.outColor);
        int color = this.cannotLaunch() ? -36495 : -6365581;
        CCGUtil.outliner.showAABB((Object)("EjectorFromBox" + String.valueOf(this)), new AABB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0).move(blockPos)).lineWidth(0.0625f).colored(color);
        int xDiff = targetPos.getX() - blockPos.getX();
        int yDiff = targetPos.getY() - blockPos.getY();
        int zDiff = targetPos.getZ() - blockPos.getZ();
        EntityLauncher launcher = new EntityLauncher(Math.abs(xDiff + zDiff), yDiff);
        double totalFlyingTicks = launcher.getTotalFlyingTicks() + 3.0;
        int segments = (int)totalFlyingTicks / 3 + 1;
        double tickOffset = totalFlyingTicks / (double)segments;
        DustParticleOptions data = new DustParticleOptions(new Color(color).asVectorF(), 1.0f);
        if (CCGUtil.mc.level == null) {
            return;
        }
        for (int i = 0; i < segments; ++i) {
            double ticks = (double)(AnimationTickHolder.getRenderTime() / 3.0f) % tickOffset + (double)i * tickOffset;
            Vec3 vec = launcher.getGlobalPos(ticks, this.getFacing().getOpposite(), blockPos);
            CCGUtil.mc.level.addParticle((ParticleOptions)data, vec.x, vec.y, vec.z, 0.0, 0.0, 0.0);
        }
    }
}

