/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGConfig;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.IItemRenderable;
import java.util.List;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;

public class Overlay {
    public static int hoverTicks;
    @NotNull
    public static ItemStack currentItemStack;

    public static void register(@NotNull RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"create_cyber_goggles", (String)"item_tooltip_overlay"), Overlay::renderOverlay);
    }

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!CCG.CONFIG.overlay.renderExtraItems || !CCG.CONFIG.gameMode.enableGoggles) {
            return;
        }
        if (CCGUtil.mc.isPaused() || CCGUtil.isInGUI() || CCGUtil.mc.options.hideGui) {
            currentItemStack = ItemStack.EMPTY;
            hoverTicks = 0;
            return;
        }
        if (!CCG.CONFIG.goggles.canRenderOnValueBox && CCGUtil.hasActivedValueBox()) {
            return;
        }
        currentItemStack = Overlay.toRenderItemStack();
        if (currentItemStack.isEmpty()) {
            hoverTicks = 0;
        } else {
            Overlay.renderItemStack(guiGraphics, currentItemStack);
        }
    }

    @NotNull
    public static ItemStack toRenderItemStack() {
        try {
            BlockEntity blockEntity = CCGUtil.getBlockEntity();
            if (blockEntity instanceof IItemRenderable) {
                IItemRenderable renderable = (IItemRenderable)blockEntity;
                return CCGUtil.orEmpty(renderable.ccg$getItemStack());
            }
            blockEntity = CCGUtil.getEntity();
            if (blockEntity instanceof IItemRenderable) {
                IItemRenderable renderable = (IItemRenderable)blockEntity;
                return CCGUtil.orEmpty(renderable.ccg$getItemStack());
            }
        }
        catch (Throwable e) {
            CCG.LOGGER.error("Failed to get item stack from IItemRenderable", e);
        }
        return ItemStack.EMPTY;
    }

    public static void renderItemStack(@NotNull GuiGraphics gui, @NotNull ItemStack itemStack) {
        Color top;
        Color back;
        TooltipFlag.Default flag = new TooltipFlag.Default(CCGUtil.mc.options.advancedItemTooltips, true);
        List tooltips = itemStack.getTooltipLines(Item.TooltipContext.of((Level)CCGUtil.mc.level), (Player)CCGUtil.mc.player, (TooltipFlag)flag);
        tooltips.set(0, Component.literal((String)" ".repeat(Mth.ceil((float)(16.0f / (float)CCGUtil.mc.font.width(" "))))).append((Component)tooltips.getFirst()));
        int tooltipTextWidth = tooltips.stream().mapToInt(arg_0 -> ((Font)CCGUtil.mc.font).width(arg_0)).max().orElse(0) + 24;
        CCGConfig.Overlay overlay = CCG.CONFIG.overlay;
        int width = gui.guiWidth();
        int height = gui.guiHeight();
        CClient cfg = AllConfigs.client();
        int x = width / 2 + (Integer)cfg.overlayOffsetX.get() + overlay.overlayOffsetX;
        int y = height / 2 + (Integer)cfg.overlayOffsetY.get() + overlay.overlayOffsetY;
        if (GoggleOverlayRenderer.hoverTicks != 0) {
            y -= (tooltips.size() + 1) * 10;
        }
        x = Mth.clamp((int)x, (int)18, (int)(width - tooltipTextWidth));
        y = Mth.clamp((int)y, (int)18, (int)height);
        boolean useCCGCustom = overlay.useCustomColor;
        Boolean useCreateCustom = (Boolean)cfg.overlayCustomColor.get();
        Color color = useCCGCustom ? new Color(overlay.backgroundColor) : (back = useCreateCustom != false ? new Color(((Integer)cfg.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f));
        Color color2 = useCCGCustom ? new Color(overlay.borderTopColor) : (top = useCreateCustom != false ? new Color(((Integer)cfg.overlayBorderColorTop.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getFirst()).copy());
        Color bot = useCCGCustom ? new Color(overlay.borderBottomColor) : (useCreateCustom != false ? new Color(((Integer)cfg.overlayBorderColorBot.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getSecond()).copy());
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        float fade = Mth.clamp((float)(((float)hoverTicks++ + CCGUtil.mc.getTimer().getRealtimeDeltaTicks()) / 24.0f), (float)0.0f, (float)1.0f);
        if (fade < 1.0f) {
            poseStack.translate(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5f) * 8.0, 0.0, 0.0);
            back.scaleAlpha(fade);
            top.scaleAlpha(fade);
            bot.scaleAlpha(fade);
        }
        RemovedGuiUtils.drawHoveringText((GuiGraphics)gui, (List)tooltips, (int)x, (int)y, (int)width, (int)height, (int)-1, (int)back.getRGB(), (int)top.getRGB(), (int)bot.getRGB(), (Font)CCGUtil.mc.font);
        float scale = 0.75f;
        int itemX = (int)((float)(x + 12) / scale);
        int itemY = (int)((float)(y - 14) / scale);
        poseStack.scale(scale, scale, 1.0f);
        GuiGameElement.of((ItemStack)itemStack).at((float)itemX, (float)itemY, 450.0f).render(gui);
        gui.renderItemDecorations(CCGUtil.mc.font, itemStack, itemX, itemY);
        poseStack.popPose();
    }

    static {
        currentItemStack = ItemStack.EMPTY;
    }
}

