/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.simibubi.create.content.equipment.armor.CardboardArmorItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.util.thread.EffectiveSide;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCGUtil {
    public static final Minecraft mc = Minecraft.getInstance();
    public static final Outliner outliner = Outliner.getInstance();
    private static HitResult cachedHitResult;
    private static float lastTick;

    @Contract(pure=true)
    public static boolean isInGUI() {
        return CCGUtil.mc.screen != null;
    }

    @Contract(pure=true)
    public static boolean isInGame() {
        return !CCGUtil.isInGUI();
    }

    public static boolean isClient() {
        return EffectiveSide.get().isClient();
    }

    public static boolean isServer() {
        return !CCGUtil.isClient();
    }

    @Nullable
    public static <T extends U, U> T getAs(@NotNull Class<T> clazz, U object) {
        return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
    }

    private static HitResult getCurrentHitResult() {
        float currentTick;
        float f = currentTick = CCGUtil.mc.level != null ? mc.getTimer().getRealtimeDeltaTicks() : 0.0f;
        if (lastTick == currentTick && cachedHitResult != null) {
            return cachedHitResult;
        }
        cachedHitResult = CCGUtil.mc.hitResult;
        lastTick = currentTick;
        return cachedHitResult;
    }

    @Contract(pure=true)
    @Nullable
    public static BlockHitResult getBlockHitResult() {
        BlockHitResult result;
        HitResult hitResult = CCGUtil.getCurrentHitResult();
        return hitResult instanceof BlockHitResult && (result = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS ? result : null;
    }

    @Contract(pure=true)
    @Nullable
    public static EntityHitResult getEntityHitResult() {
        EntityHitResult result;
        HitResult hitResult = CCGUtil.getCurrentHitResult();
        return hitResult instanceof EntityHitResult ? (result = (EntityHitResult)hitResult) : null;
    }

    @Nullable
    public static BlockEntity getBlockEntity() {
        if (CCGUtil.mc.level == null) {
            return null;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null || result.getType() == HitResult.Type.MISS) {
            return null;
        }
        return CCGUtil.mc.level.getBlockEntity(result.getBlockPos());
    }

    @Nullable
    public static <T extends BlockEntity> T getBlockEntity(Class<T> clazz) {
        return (T)((BlockEntity)CCGUtil.getAs(clazz, CCGUtil.getBlockEntity()));
    }

    @Nullable
    public static Block getBlock() {
        if (CCGUtil.mc.level == null) {
            return null;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null || result.getType() == HitResult.Type.MISS) {
            return null;
        }
        return CCGUtil.mc.level.getBlockState(result.getBlockPos()).getBlock();
    }

    @Nullable
    public static <T extends Block> T getBlock(Class<T> clazz) {
        return (T)((Block)CCGUtil.getAs(clazz, CCGUtil.getBlock()));
    }

    @Nullable
    public static Entity getEntity() {
        EntityHitResult result = CCGUtil.getEntityHitResult();
        return result != null ? result.getEntity() : null;
    }

    @Contract(value="!null -> param1", pure=true)
    @NotNull
    public static ItemStack orEmpty(@Nullable ItemStack itemStack) {
        return Objects.requireNonNullElse(itemStack, ItemStack.EMPTY);
    }

    @Nullable
    public static ItemStack getSelectedFilter() {
        if (CCGUtil.isInGUI()) {
            Screen screen = CCGUtil.mc.screen;
            if (!(screen instanceof AbstractContainerScreen)) {
                return null;
            }
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot slot = screen2.getSlotUnderMouse();
            return slot == null ? null : slot.getItem();
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        SmartBlockEntity sbe = CCGUtil.getBlockEntity(SmartBlockEntity.class);
        if (sbe == null || result == null) {
            return null;
        }
        FilteringBehaviour behaviour = (FilteringBehaviour)sbe.getBehaviour(FilteringBehaviour.TYPE);
        return behaviour == null ? null : behaviour.getFilter(result.getDirection());
    }

    @NotNull
    public static AABB getBounds(BlockPos blockPos) {
        if (CCGUtil.mc.level == null) {
            return Shapes.block().bounds();
        }
        VoxelShape shape = CCGUtil.mc.level.getBlockState(blockPos).getShape((BlockGetter)CCGUtil.mc.level, blockPos);
        return (shape.isEmpty() ? Shapes.block() : shape).bounds().move(blockPos);
    }

    public static boolean hasActivedValueBox() {
        for (Outliner.OutlineEntry entry : outliner.getOutlines().values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox)) continue;
            ValueBox valueBox = (ValueBox)outline;
            if (valueBox.isPassive) continue;
            return true;
        }
        return false;
    }

    public static boolean testForStealth() {
        if (CCGUtil.mc.player == null) {
            return false;
        }
        boolean allMatch = Stream.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET).allMatch(slot -> CCGUtil.mc.player.getItemBySlot(slot).getItem() instanceof CardboardArmorItem);
        return CCG.CONFIG.chainConveyor.cardBoardedYourself && !CCGUtil.mc.player.getAbilities().flying && allMatch;
    }

    public static boolean hasItemInHand() {
        return CCGUtil.mc.player != null && !Stream.of(CCGUtil.mc.player.getMainHandItem(), CCGUtil.mc.player.getOffhandItem()).allMatch(ItemStack::isEmpty);
    }

    public static void playSound(SoundEvent sound, float pitch, float volume) {
        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void toggleConfig(boolean keyDown, boolean enabled, Consumer<Boolean> setter, String messageKey) {
        if (!keyDown) {
            return;
        }
        if (CCGUtil.isInGUI()) {
            return;
        }
        boolean newEnabled = !enabled;
        setter.accept(newEnabled);
        if (CCGUtil.mc.player == null) {
            return;
        }
        CCGLang.translate(messageKey, new Object[0]).space().add(CCGLang.enabled(newEnabled)).sendStatus((Player)CCGUtil.mc.player);
    }

    public static void sendAction(ServerboundPlayerCommandPacket.Action action) {
        if (CCGUtil.mc.player == null) {
            return;
        }
        CCGUtil.mc.player.connection.send((Packet)new ServerboundPlayerCommandPacket((Entity)CCGUtil.mc.player, action));
    }

    public static void sendToServer(CustomPacketPayload packet) {
        CatnipServices.NETWORK.sendToServer(packet);
    }
}

