/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.provider;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.event.Outliner;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.IOutlineRenderable;
import io.github.forgestove.create_cyber_goggles.core.util.TooltipUtil;
import java.util.List;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EncasedFanBlockEntity.class})
public abstract class EncasedFanBlockEntityMixin
extends KineticBlockEntity
implements IHaveGoggleInformation,
IOutlineRenderable {
    @Shadow
    public AirCurrent airCurrent;

    public EncasedFanBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean add = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!CCG.CONFIG.goggles.enhancedInfo || this.getSpeed() == 0.0f) {
            return add;
        }
        return TooltipUtil.fan(tooltip, this.airCurrent.pushing, this.airCurrent.maxDistance, 1);
    }

    @Override
    public void ccg$render() {
        int color = Outliner.getColor(this.airCurrent.pushing);
        AABB bounds = this.airCurrent.bounds;
        CCGUtil.outliner.chaseAABB((Object)("FanAirBox" + String.valueOf(this)), bounds).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = Outliner.getNumberOfFlowBoxes(this.airCurrent.maxDistance);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = Outliner.getOffset(i, numberOfFlowBoxes);
            double offsetDistance = (double)this.airCurrent.maxDistance * offset;
            Direction.Axis axis = this.airCurrent.direction.getAxis();
            double min = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> bounds.minX;
                case Direction.Axis.Y -> bounds.minY;
                case Direction.Axis.Z -> bounds.minZ;
            };
            double max = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> bounds.maxX;
                case Direction.Axis.Y -> bounds.maxY;
                case Direction.Axis.Z -> bounds.maxZ;
            };
            double pos = this.airCurrent.pushing == this.airCurrent.direction.getAxisDirection().getStep() > 0 ? min + offsetDistance : max - offsetDistance;
            AABB flowBound = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> new AABB(pos, bounds.minY, bounds.minZ, pos, bounds.maxY, bounds.maxZ);
                case Direction.Axis.Y -> new AABB(bounds.minX, pos, bounds.minZ, bounds.maxX, pos, bounds.maxZ);
                case Direction.Axis.Z -> new AABB(bounds.minX, bounds.minY, pos, bounds.maxX, bounds.maxY, pos);
            };
            String id = "FanAirFlowBox" + String.valueOf(this) + i;
            if (offset > 0.98) {
                CCGUtil.outliner.remove((Object)id);
                continue;
            }
            CCGUtil.outliner.chaseAABB((Object)id, flowBound).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }
}

