/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.equipment.toolbox.ToolboxInventory;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

public class ItemTooltip {
    public static void itemTooltip(@NotNull ItemTooltipEvent event) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        ItemTooltip.goggles(stack, tooltip);
        ItemTooltip.backtank(stack, tooltip);
        ItemTooltip.divingBoots(stack, tooltip);
        ItemTooltip.wrench(stack, tooltip);
        ItemTooltip.toolbox(stack, tooltip);
    }

    private static void goggles(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!(stack.getItem() instanceof GogglesItem)) {
            return;
        }
        MutableComponent component = CCGLang.enabled(GogglesItem.isWearingGoggles((Player)CCGUtil.mc.player)).component();
        tooltip.add(1, (Component)component);
    }

    private static void backtank(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!(stack.getItem() instanceof BacktankItem)) {
            return;
        }
        MutableComponent component = CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).add(CCGLang.fraction(BacktankUtil.getAir((ItemStack)stack), BacktankUtil.maxAir((ItemStack)stack))).component();
        tooltip.add(1, (Component)component);
    }

    private static void divingBoots(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!(stack.getItem() instanceof DivingBootsItem)) {
            return;
        }
        MutableComponent component = CCGLang.enabled(CCG.CONFIG.misc.allowDivingBoot).component();
        tooltip.add(1, (Component)component);
    }

    private static void wrench(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!(stack.getItem() instanceof WrenchItem)) {
            return;
        }
        MutableComponent component = CCGLang.configBuilder().translate("option.wrench.leftClickFastDismantle", new Object[0]).space().add(CCGLang.enabled(CCG.CONFIG.wrench.leftClickFastDismantle)).component();
        tooltip.add(1, (Component)component);
    }

    private static void toolbox(@NotNull ItemStack stack, List<Component> tooltip) {
        if (!AllTags.AllItemTags.TOOLBOXES.matches(stack)) {
            return;
        }
        ToolboxInventory inventory = (ToolboxInventory)stack.getComponents().get(AllDataComponents.TOOLBOX_INVENTORY);
        if (inventory == null) {
            return;
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            if (slot.isEmpty()) continue;
            CCGLang.item(slot).addTo(list);
        }
        tooltip.addAll(1, list);
    }
}

