/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.content.contraptions.wrench.RadialWrenchMenuSubmitPacket;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import java.util.stream.Stream;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class PlayerInteract {
    private static long lastDismantleTime;
    private static long dismantleDelay;

    public static void tick(ClientTickEvent.Post ignoredEvent) {
        if (dismantleDelay < 10L) {
            ++dismantleDelay;
        }
    }

    public static void leftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (CCGUtil.isServer()) {
            return;
        }
        PlayerInteract.wrench(event);
    }

    private static void wrench(PlayerInteractEvent.LeftClickBlock event) {
        InteractionHand handWithWrench;
        boolean canDismantle;
        if (!CCG.CONFIG.wrench.leftClickFastDismantle) {
            return;
        }
        if (dismantleDelay > 0L) {
            --dismantleDelay;
        }
        boolean bl = canDismantle = System.currentTimeMillis() - lastDismantleTime > dismantleDelay * 20L;
        if (!canDismantle) {
            return;
        }
        PlayerInteractEvent.LeftClickBlock.Action action = event.getAction();
        if (action != PlayerInteractEvent.LeftClickBlock.Action.START && action != PlayerInteractEvent.LeftClickBlock.Action.CLIENT_HOLD) {
            return;
        }
        LocalPlayer player = CCGUtil.mc.player;
        if (player == null || CCGUtil.mc.player.isCreative() || CCGUtil.mc.gameMode == null) {
            return;
        }
        Object object = player.getMainHandItem().getItem() instanceof WrenchItem ? InteractionHand.MAIN_HAND : (handWithWrench = player.getOffhandItem().getItem() instanceof WrenchItem ? InteractionHand.OFF_HAND : null);
        if (handWithWrench == null) {
            return;
        }
        if (!(CCGUtil.getBlock() instanceof IWrenchable)) {
            return;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null) {
            return;
        }
        CCGUtil.sendAction(ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY);
        CCGUtil.mc.gameMode.useItemOn(player, handWithWrench, result);
        CCGUtil.sendAction(ServerboundPlayerCommandPacket.Action.RELEASE_SHIFT_KEY);
        lastDismantleTime = System.currentTimeMillis();
        event.setCanceled(true);
    }

    public static void rightClick(PlayerInteractEvent.RightClickBlock event) {
        if (CCGUtil.isServer()) {
            return;
        }
        PlayerInteract.enacesdPipe(event);
    }

    private static void enacesdPipe(PlayerInteractEvent.RightClickBlock event) {
        boolean currentState;
        BooleanProperty property;
        if (!CCG.CONFIG.wrench.betterEncasedPipe) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().getBlockState(pos);
        if (!(state.getBlock() instanceof EncasedPipeBlock)) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (CCGUtil.mc.player == null) {
            return;
        }
        boolean anyMatch = Stream.of(CCGUtil.mc.player.getMainHandItem(), CCGUtil.mc.player.getOffhandItem()).map(ItemStack::getItem).anyMatch(item -> item instanceof BlockItem || item instanceof WrenchItem || item instanceof DebugStickItem);
        if (anyMatch) {
            return;
        }
        Direction clickedFace = event.getHitVec().getDirection();
        if (CCGUtil.mc.player.isShiftKeyDown()) {
            clickedFace = clickedFace.getOpposite();
        }
        BlockState newState = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(!(currentState = ((Boolean)state.getValue((Property)(property = (BooleanProperty)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(clickedFace)))).booleanValue())));
        CCGUtil.sendToServer((CustomPacketPayload)new RadialWrenchMenuSubmitPacket(pos, newState));
        CCGUtil.mc.player.swing(CCGUtil.mc.player.getUsedItemHand());
    }

    static {
        dismantleDelay = 10L;
    }
}

