/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.goggles;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.foundation.item.TooltipHelper;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DeployerBlockEntity.class})
public abstract class DeployerBlockEntityMixin
extends KineticBlockEntity {
    @Shadow
    protected List<ItemStack> overflowItems;

    public DeployerBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Inject(method={"addToTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    public void addToTooltip(List<Component> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> returnable) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        if (this.overflowItems.isEmpty()) {
            returnable.setReturnValue((Object)false);
            return;
        }
        super.addToTooltip(tooltip, isPlayerSneaking);
        TooltipHelper.addHint(tooltip, (String)"hint.full_deployer", (Object[])new Object[0]);
        this.overflowItems.forEach(itemStack -> CCGLang.item(itemStack).forGoggles(tooltip));
        returnable.setReturnValue((Object)true);
    }

    @Inject(method={"addToGoggleTooltip"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/deployer/DeployerBlockEntity;calculateStressApplied()F")}, cancellable=true)
    public void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> returnable) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        returnable.setReturnValue((Object)true);
    }
}

