/*
 * Decompiled with CFR 0.152.
 */
package com.forgestove.create_cyber_goggles.event;

import com.forgestove.create_cyber_goggles.CreateCyberGoggles;
import com.forgestove.create_cyber_goggles.util.Util;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class OverlayRenderer {
    public static void register() {
        HudRenderCallback.EVENT.register(OverlayRenderer::renderOverlay);
    }

    public static void renderOverlay(GuiGraphics guiGraphics, float tickDelta) {
        HitResult hitResult;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.isPaused() || mc.screen != null) {
            return;
        }
        ClientLevel level = mc.level;
        if (level == null || !((hitResult = mc.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockEntity blockEntity = level.getBlockEntity(blockHitResult.getBlockPos());
        boolean renderExtraItems = CreateCyberGoggles.config.goggles.renderExtraItems;
        if (renderExtraItems && blockEntity instanceof DepotBlockEntity) {
            DepotBlockEntity depotBlockEntity = (DepotBlockEntity)blockEntity;
            Util.renderItemStack(guiGraphics, depotBlockEntity.getHeldItem());
        } else if (CreateCyberGoggles.config.goggles.enableKineticEffect && blockEntity instanceof KineticBlockEntity) {
            KineticBlockEntity kineticBlockEntity = (KineticBlockEntity)blockEntity;
            if (!blockHitResult.getBlockPos().equals((Object)kineticBlockEntity.getBlockPos())) {
                return;
            }
            float speed = kineticBlockEntity.getSpeed();
            if (speed == 0.0f) {
                return;
            }
            BlockState state = kineticBlockEntity.getBlockState();
            Block block = state.getBlock();
            if (!(block instanceof KineticBlock)) {
                return;
            }
            KineticBlock kineticBlock = (KineticBlock)block;
            Direction.Axis rotationAxis = kineticBlock.getRotationAxis(state);
            if (rotationAxis == null) {
                return;
            }
            Vec3 center = VecHelper.getCenterOf((Vec3i)kineticBlockEntity.getBlockPos());
            IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of((float)speed);
            level.addParticle((ParticleOptions)new RotationIndicatorParticleData(speedLevel.getColor(), (float)Math.max(15, speedLevel.getParticleSpeed()) * Math.signum(speed), kineticBlock.getParticleInitialRadius(), kineticBlock.getParticleTargetRadius(), 10, rotationAxis.name().charAt(0)), center.x, center.y, center.z, 0.0, 0.0, 0.0);
        }
    }
}

