/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeStove.create_cyber_goggles.config;

import com.ForgeStove.create_cyber_goggles.config.ClientConfig;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.createmod.catnip.config.ConfigBase;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    @Nullable
    private static ClientConfig client;

    @NotNull
    public static Set<Map.Entry<ModConfig.Type, ConfigBase>> registerConfigs() {
        client = Configs.register(ClientConfig::new, ModConfig.Type.CLIENT);
        return CONFIGS.entrySet();
    }

    @NotNull
    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ModConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ModConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void onLoad(ModConfig config) {
        for (ConfigBase configBase : CONFIGS.values()) {
            if (configBase.specification != config.getSpec()) continue;
            configBase.onLoad();
        }
    }

    public static void onReload(ModConfig config) {
        for (ConfigBase configBase : CONFIGS.values()) {
            if (configBase.specification != config.getSpec()) continue;
            configBase.onReload();
        }
    }

    public static ClientConfig client() {
        if (client != null) {
            return client;
        }
        throw new AssertionError((Object)"Create Cyber Goggles Client Config was accessed, but not registered yet!");
    }
}

